% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinDNA.R
\name{ordinDNA}
\alias{ordinDNA}
\title{Calculates a Principal Components Ordination of genetic distances}
\usage{
ordinDNA(distobj, sppVector, ...)
}
\arguments{
\item{distobj}{A distance matrix.}

\item{sppVector}{The species vector (see \code{\link{sppVector}}).}

\item{...}{Other arguments to be passed to \code{\link{plot.ordinDNA}}.}
}
\value{
Plots an ordination of the first two major axes showing the
positions of each individual (squares), the centroid of each species
(circular bullet and name of species), and the variation in the species
(large circle, the radius of which is the distance to the furthest
individual from the centroid).

Additionally returns a list of class \code{"ordinDNA"} with the following
elements: \item{pco}{Output of the Principal Coordinates Analysis.}
\item{sppVector}{Character vector giving the species vector.}
}
\description{
Calculates Principical Coonrdinates Analysis on a matrix of genetic
distances and plots an ordination of the first two major axes.
}
\details{
This function is a wrapper for \code{\link{cmdscale}}, which performs a
Principal Coordinates Analysis on the distance matrix given. In addition, it
plots an ordination of the genetic distance matrix given, showing the
relative distance between each of the species in the dataset. It is
presented as an alternative to the neighbour-joining trees which are
frequently used for the visualisation of DNA barcoding data. NJ trees show
hypotheses of relationships, which are inappropriate for the questions
usally asked in DNA barcoding studies.

The distance between the centroids of the clusters are roughly proportional
to the genetic distances between the species. NOTE: it is important to
remember that the plot shows only one plane of a multi-dimensional space.
Species with overlapping circles are not necessarily conspecific. Further
exploration is required.
}
\examples{


data(dolomedes)
doloDist <- ape::dist.dna(dolomedes)
doloSpp <- substr(dimnames(dolomedes)[[1]], 1, 5)

doloOrd <- ordinDNA(doloDist, doloSpp)
doloOrd

}
\seealso{
\code{\link{cmdscale}}, \code{\link{plot.ordinDNA}}
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Barcoding}
