/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hpsf.ReadingNotSupportedException;
import org.apache.poi.hpsf.TypeWriter;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.Variant;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.util.LittleEndian;

public class VariantSupport
extends Variant {
    private static boolean logUnsupportedTypes = false;
    protected static List unsupportedMessage;
    public static final int[] SUPPORTED_TYPES;

    public static void setLogUnsupportedTypes(boolean logUnsupportedTypes) {
        VariantSupport.logUnsupportedTypes = logUnsupportedTypes;
    }

    public static boolean isLogUnsupportedTypes() {
        return logUnsupportedTypes;
    }

    protected static void writeUnsupportedTypeMessage(UnsupportedVariantTypeException ex) {
        if (VariantSupport.isLogUnsupportedTypes()) {
            Long vt;
            if (unsupportedMessage == null) {
                unsupportedMessage = new LinkedList();
            }
            if (!unsupportedMessage.contains(vt = Long.valueOf(ex.getVariantType()))) {
                System.err.println(ex.getMessage());
                unsupportedMessage.add(vt);
            }
        }
    }

    public boolean isSupportedType(int variantType) {
        for (int i = 0; i < SUPPORTED_TYPES.length; ++i) {
            if (variantType != SUPPORTED_TYPES[i]) continue;
            return true;
        }
        return false;
    }

    public static Object read(byte[] src, int offset, int length, long type, int codepage) throws ReadingNotSupportedException, UnsupportedEncodingException {
        Object value;
        int o1 = offset;
        int l1 = length - 4;
        long lType = type;
        if (codepage == 1200 && type == 30L) {
            lType = 31L;
        }
        switch ((int)lType) {
            case 0: {
                value = null;
                break;
            }
            case 2: {
                value = (int)LittleEndian.getShort(src, o1);
                break;
            }
            case 3: {
                value = LittleEndian.getInt(src, o1);
                break;
            }
            case 20: {
                value = LittleEndian.getLong(src, o1);
                break;
            }
            case 5: {
                value = new Double(LittleEndian.getDouble(src, o1));
                break;
            }
            case 64: {
                long low = LittleEndian.getUInt(src, o1);
                long high = LittleEndian.getUInt(src, o1 += 4);
                value = Util.filetimeToDate((int)high, (int)low);
                break;
            }
            case 30: {
                int first = o1 + 4;
                long last = (long)first + LittleEndian.getUInt(src, o1) - 1L;
                o1 += 4;
                while (src[(int)last] == 0 && (long)first <= last) {
                    --last;
                }
                int l = (int)(last - (long)first + 1L);
                value = codepage != -1 ? new String(src, first, l, VariantSupport.codepageToEncoding(codepage)) : new String(src, first, l);
                break;
            }
            case 31: {
                int first = o1 + 4;
                long last = (long)first + LittleEndian.getUInt(src, o1) - 1L;
                long l = last - (long)first;
                o1 += 4;
                StringBuffer b = new StringBuffer((int)(last - (long)first));
                int i = 0;
                while ((long)i <= l) {
                    int i1 = o1 + i * 2;
                    int i2 = i1 + 1;
                    int high = src[i2] << 8;
                    int low = src[i1] & 0xFF;
                    char c = (char)(high | low);
                    b.append(c);
                    ++i;
                }
                while (b.length() > 0 && b.charAt(b.length() - 1) == '\u0000') {
                    b.setLength(b.length() - 1);
                }
                value = b.toString();
                break;
            }
            case 71: {
                if (l1 < 0) {
                    l1 = LittleEndian.getInt(src, o1);
                    o1 += 4;
                }
                byte[] v = new byte[l1];
                System.arraycopy(src, o1, v, 0, v.length);
                value = v;
                break;
            }
            case 11: {
                long bool = LittleEndian.getUInt(src, o1);
                if (bool != 0L) {
                    value = Boolean.TRUE;
                    break;
                }
                value = Boolean.FALSE;
                break;
            }
            default: {
                byte[] v = new byte[l1];
                for (int i = 0; i < l1; ++i) {
                    v[i] = src[o1 + i];
                }
                throw new ReadingNotSupportedException(type, v);
            }
        }
        return value;
    }

    public static String codepageToEncoding(int codepage) throws UnsupportedEncodingException {
        if (codepage <= 0) {
            throw new UnsupportedEncodingException("Codepage number may not be " + codepage);
        }
        switch (codepage) {
            case 1200: {
                return "UTF-16";
            }
            case 1201: {
                return "UTF-16BE";
            }
            case 65001: {
                return "UTF-8";
            }
            case 37: {
                return "cp037";
            }
            case 936: {
                return "GBK";
            }
            case 949: {
                return "ms949";
            }
            case 1250: {
                return "windows-1250";
            }
            case 1251: {
                return "windows-1251";
            }
            case 1252: {
                return "windows-1252";
            }
            case 1253: {
                return "windows-1253";
            }
            case 1254: {
                return "windows-1254";
            }
            case 1255: {
                return "windows-1255";
            }
            case 1256: {
                return "windows-1256";
            }
            case 1257: {
                return "windows-1257";
            }
            case 1258: {
                return "windows-1258";
            }
            case 1361: {
                return "johab";
            }
            case 10000: {
                return "MacRoman";
            }
            case 10001: {
                return "SJIS";
            }
            case 10002: {
                return "Big5";
            }
            case 10003: {
                return "EUC-KR";
            }
            case 10004: {
                return "MacArabic";
            }
            case 10005: {
                return "MacHebrew";
            }
            case 10006: {
                return "MacGreek";
            }
            case 10007: {
                return "MacCyrillic";
            }
            case 10008: {
                return "EUC_CN";
            }
            case 10010: {
                return "MacRomania";
            }
            case 10017: {
                return "MacUkraine";
            }
            case 10021: {
                return "MacThai";
            }
            case 10029: {
                return "MacCentralEurope";
            }
            case 10079: {
                return "MacIceland";
            }
            case 10081: {
                return "MacTurkish";
            }
            case 10082: {
                return "MacCroatian";
            }
            case 20127: 
            case 65000: {
                return "US-ASCII";
            }
            case 20866: {
                return "KOI8-R";
            }
            case 28591: {
                return "ISO-8859-1";
            }
            case 28592: {
                return "ISO-8859-2";
            }
            case 28593: {
                return "ISO-8859-3";
            }
            case 28594: {
                return "ISO-8859-4";
            }
            case 28595: {
                return "ISO-8859-5";
            }
            case 28596: {
                return "ISO-8859-6";
            }
            case 28597: {
                return "ISO-8859-7";
            }
            case 28598: {
                return "ISO-8859-8";
            }
            case 28599: {
                return "ISO-8859-9";
            }
            case 50220: 
            case 50221: 
            case 50222: {
                return "ISO-2022-JP";
            }
            case 50225: {
                return "ISO-2022-KR";
            }
            case 51932: {
                return "EUC-JP";
            }
            case 51949: {
                return "EUC-KR";
            }
            case 52936: {
                return "GB2312";
            }
            case 54936: {
                return "GB18030";
            }
            case 932: {
                return "SJIS";
            }
        }
        return "cp" + codepage;
    }

    public static int write(OutputStream out, long type, Object value, int codepage) throws IOException, WritingNotSupportedException {
        int length = 0;
        switch ((int)type) {
            case 11: {
                int trueOrFalse = (Boolean)value != false ? 1 : 0;
                length = TypeWriter.writeUIntToStream(out, trueOrFalse);
                break;
            }
            case 30: {
                byte[] bytes = codepage == -1 ? ((String)value).getBytes() : ((String)value).getBytes(VariantSupport.codepageToEncoding(codepage));
                length = TypeWriter.writeUIntToStream(out, bytes.length + 1);
                byte[] b = new byte[bytes.length + 1];
                System.arraycopy(bytes, 0, b, 0, bytes.length);
                b[b.length - 1] = 0;
                out.write(b);
                length += b.length;
                break;
            }
            case 31: {
                int nrOfChars = ((String)value).length() + 1;
                length += TypeWriter.writeUIntToStream(out, nrOfChars);
                char[] s = Util.pad4((String)value);
                for (int i = 0; i < s.length; ++i) {
                    int high = (s[i] & 0xFF00) >> 8;
                    int low = s[i] & 0xFF;
                    byte highb = (byte)high;
                    byte lowb = (byte)low;
                    out.write(lowb);
                    out.write(highb);
                    length += 2;
                }
                out.write(0);
                out.write(0);
                length += 2;
                break;
            }
            case 71: {
                byte[] b = (byte[])value;
                out.write(b);
                length = b.length;
                break;
            }
            case 0: {
                TypeWriter.writeUIntToStream(out, 0L);
                length = 4;
                break;
            }
            case 2: {
                TypeWriter.writeToStream(out, ((Integer)value).shortValue());
                length = 2;
                break;
            }
            case 3: {
                if (!(value instanceof Integer)) {
                    throw new ClassCastException("Could not cast an object to " + Integer.class.toString() + ": " + value.getClass().toString() + ", " + value.toString());
                }
                length += TypeWriter.writeToStream(out, (Integer)value);
                break;
            }
            case 20: {
                TypeWriter.writeToStream(out, (Long)value);
                length = 8;
                break;
            }
            case 5: {
                length += TypeWriter.writeToStream(out, (Double)value);
                break;
            }
            case 64: {
                long filetime = Util.dateToFileTime((Date)value);
                int high = (int)(filetime >> 32 & 0xFFFFFFFFL);
                int low = (int)(filetime & 0xFFFFFFFFL);
                length += TypeWriter.writeUIntToStream(out, 0xFFFFFFFFL & (long)low);
                length += TypeWriter.writeUIntToStream(out, 0xFFFFFFFFL & (long)high);
                break;
            }
            default: {
                if (value instanceof byte[]) {
                    byte[] b = (byte[])value;
                    out.write(b);
                    length = b.length;
                    VariantSupport.writeUnsupportedTypeMessage(new WritingNotSupportedException(type, value));
                    break;
                }
                throw new WritingNotSupportedException(type, value);
            }
        }
        return length;
    }

    static {
        SUPPORTED_TYPES = new int[]{0, 2, 3, 20, 5, 64, 30, 31, 71, 11};
    }
}

