/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.stack.StackDockProperty;

public class CStackLocation
extends AbstractStackholdingLocation {
    private int index;
    private CLocation parent;

    public CStackLocation(CLocation parent) {
        this(parent, Integer.MAX_VALUE);
    }

    public CStackLocation(CLocation parent, int index) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent must not be null");
        }
        this.parent = parent;
        this.index = index;
    }

    public CLocation getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public String findRoot() {
        return this.parent.findRoot();
    }

    public ExtendedMode findMode() {
        return this.parent.findMode();
    }

    public DockableProperty findProperty(DockableProperty successor) {
        StackDockProperty stack = new StackDockProperty(this.index);
        stack.setSuccessor(successor);
        return this.parent.findProperty(stack);
    }

    public CLocation aside() {
        if (this.index == Integer.MAX_VALUE) {
            return this;
        }
        return new CStackLocation(this.parent, this.index + 1);
    }

    public String toString() {
        return String.valueOf(this.parent) + " [stack " + this.index + "]";
    }
}

