/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;

class TipUtil {
    private TipUtil() {
    }

    public static Color getToolTipBackground() {
        Color color = UIManager.getColor("ToolTip.background");
        if ((color == null || UIManager.getLookAndFeel().getName().equals("Nimbus")) && (color = UIManager.getColor("info")) == null) {
            color = SystemColor.info;
        }
        if (color instanceof ColorUIResource) {
            color = new Color(color.getRGB());
        }
        return color;
    }

    public static void tweakTipEditorPane(JEditorPane jEditorPane) {
        Serializable serializable;
        Serializable serializable2;
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            serializable2 = jEditorPane.getSelectionColor();
            serializable = jEditorPane.getSelectedTextColor();
            jEditorPane.setUI(new BasicEditorPaneUI());
            jEditorPane.setSelectedTextColor((Color)serializable);
            jEditorPane.setSelectionColor((Color)serializable2);
        }
        jEditorPane.setEditable(false);
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jEditorPane.getCaret().setSelectionVisible(true);
        jEditorPane.setBackground(TipUtil.getToolTipBackground());
        serializable2 = UIManager.getFont("Label.font");
        if (serializable2 == null) {
            serializable2 = new Font("SansSerif", 0, 12);
        }
        serializable = (HTMLDocument)jEditorPane.getDocument();
        ((HTMLDocument)serializable).getStyleSheet().addRule("body { font-family: " + ((Font)serializable2).getFamily() + "; font-size: " + ((Font)serializable2).getSize() + "pt; }");
    }
}

