/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Range<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> comparator;
    private final T minimum;
    private final T maximum;
    private transient int hashCode = 0;
    private transient String toString = null;

    public static <T extends Comparable<T>> Range<T> is(T element) {
        return new Range<T>(element, element, ComparableComparator.getInstance());
    }

    public static <T extends Comparable<T>> Range<T> between(T element1, T element2) {
        return new Range<T>(element1, element2, ComparableComparator.getInstance());
    }

    public static <T> Range<T> is(T element, Comparator<T> c) {
        return new Range<T>(element, element, c);
    }

    public static <T> Range<T> between(T element1, T element2, Comparator<T> c) {
        return new Range<T>(element1, element2, c);
    }

    private Range(T element1, T element2, Comparator<T> c) {
        if (element1 == null || element2 == null) {
            throw new IllegalArgumentException("Elements in a range must not be null: element1=" + element1 + ", element2=" + element2);
        }
        if (c == null) {
            throw new IllegalArgumentException("Comparator must not be null");
        }
        if (c.compare(element1, element2) < 1) {
            this.minimum = element1;
            this.maximum = element2;
        } else {
            this.minimum = element2;
            this.maximum = element1;
        }
        this.comparator = c;
    }

    public T getMinimum() {
        return this.minimum;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public boolean isDefaultNaturalOrdering() {
        return this.comparator == ComparableComparator.INSTANCE;
    }

    public boolean contains(T element) {
        if (element == null) {
            return false;
        }
        return this.comparator.compare(element, this.minimum) > -1 && this.comparator.compare(element, this.maximum) < 1;
    }

    public boolean elementBefore(T element) {
        if (element == null) {
            return false;
        }
        return this.comparator.compare(element, this.minimum) < 0;
    }

    public boolean elementAfter(T element) {
        if (element == null) {
            return false;
        }
        return this.comparator.compare(element, this.maximum) > 0;
    }

    public int elementCompareTo(T element) {
        if (element == null) {
            throw new NullPointerException("Element is null");
        }
        if (this.elementBefore(element)) {
            return -1;
        }
        if (this.elementAfter(element)) {
            return 1;
        }
        return 0;
    }

    public boolean containsRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return this.contains(range.getMinimum()) && this.contains(range.getMaximum());
    }

    public boolean overlapsRange(Range<T> range) {
        if (range == null) {
            return false;
        }
        return range.contains(this.minimum) || range.contains(this.maximum) || this.contains(range.getMinimum());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Range range = (Range)obj;
        return this.getMinimum().equals(range.getMinimum()) && this.getMaximum().equals(range.getMaximum());
    }

    public int hashCode() {
        int result = this.hashCode;
        if (this.hashCode == 0) {
            result = 17;
            result = 37 * result + this.getClass().hashCode();
            result = 37 * result + this.minimum.hashCode();
            this.hashCode = result = 37 * result + this.maximum.hashCode();
        }
        return result;
    }

    public String toString() {
        String result = this.toString;
        if (result == null) {
            StringBuilder buf = new StringBuilder(32);
            buf.append("Range[");
            buf.append(this.minimum);
            buf.append(',');
            buf.append(this.maximum);
            buf.append(']');
            this.toString = result = buf.toString();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableComparator<E extends Comparable<? super E>>
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static final ComparableComparator<?> INSTANCE = new ComparableComparator();

        public static <E extends Comparable<? super E>> ComparableComparator<E> getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(E obj1, E obj2) {
            return obj1.compareTo(obj2);
        }

        public int hashCode() {
            return "ComparableComparator".hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this == object || null != object && object.getClass().equals(this.getClass());
        }
    }
}

