% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothGraphLearning.R
\name{learn_smooth_graph}
\alias{learn_smooth_graph}
\title{Learn a graph from smooth signals

This function learns a connected graph given an observed signal matrix
using the method proposed by Kalofilias (2016).}
\usage{
learn_smooth_graph(
  X,
  alpha = 0.01,
  beta = 1e-04,
  step_size = 0.01,
  maxiter = 1000,
  tol = 1e-04
)
}
\arguments{
\item{X}{a p-by-n data matrix, where p is the number of nodes and n is the
number of observations}

\item{alpha}{hyperparameter that controls the importance of the Dirichlet
energy penalty}

\item{beta}{hyperparameter that controls the importance of the L2-norm
regularization}

\item{step_size}{learning rate}

\item{maxiter}{maximum number of iterations}

\item{tol}{relative tolerance used as stopping criteria}
}
\description{
Learn a graph from smooth signals

This function learns a connected graph given an observed signal matrix
using the method proposed by Kalofilias (2016).
}
\references{
V. Kalofolias, "How to learn a graph from smooth signals", in Proc. Int.
            Conf. Artif. Intell. Statist., 2016, pp. 920–929.
}
