\name{rcell}
\alias{rcell}
\title{Simulate Baddeley-Silverman Cell Process}
\description{
  Generates a random point pattern using the 
  cell process. The \eqn{K} function of the cell process is
  indistinguishable from the \eqn{K} function of Complete Spatial Randomness.
}
\usage{
 rcell(win=square(1), nx, ny=nx, dx=NULL, dy=NULL)
}
\arguments{
  \item{win}{
    A window. 
    An object of class \code{\link{owin}},
    or data in any format acceptable to \code{\link{as.owin}()}.
  }
  \item{dx}{Width of the cells. Incompatible with \code{nx}.
  }
  \item{dy}{Height of the cells.
    Incompatible with \code{ny}.
  }
  \item{nx}{Number of columns of cells in the window.
    Incompatible with \code{dx}.
  }
  \item{ny}{Number of rows of cells in the window.
    Incompatible with \code{dy}.
  }
}
\value{
  A point pattern (object of class \code{"ppp"}).
}
\details{ 
  This function generates a simulated realisation of the \dQuote{cell process}
  (Baddeley and Silverman, 1984), a random point process
  with the same second-order properties as the uniform Poisson process.
  In particular, the \eqn{K} function of this process is identical to
  the \eqn{K} function of the uniform Poisson process (aka Complete
  Spatial Randomness). The same holds for the pair correlation function
  and all other second-order properties.
  The cell process is a counterexample to the claim that the
  \eqn{K} function completely characterises a point pattern.
  
  A cell process is generated by dividing space into equal rectangular
  tiles. In each tile, a random number \eqn{N} of points is placed,
  where \eqn{N} takes the values \eqn{0}, \eqn{1} and \eqn{10}
  with probabilities \eqn{1/10}, \eqn{8/9} and \eqn{1/90} respectively.
  The points within a tile are independent and uniformly distributed in
  that tile, and the numbers of points in different tiles are
  independent random integers. 

  In the function \code{rcell} the tile dimensions are determined
  by the quantities \code{dx, dy}
  if they are present. If they are absent, then the grid spacing is
  determined so that there will be \code{nx} columns and \code{ny} rows
  of tiles in the bounding rectangle of \code{win}.
  The cell process is then generated in these tiles.

  Some of the resulting random points may lie outside the window \code{win}:
  if they do, they are deleted.
  The result is a point pattern inside the window \code{win}.
}
\seealso{
  \code{\link{rstrat}},
  \code{\link{rsyst}},
  \code{\link{runifpoint}},
  \code{\link{Kest}}
}
\examples{
  X <- rcell(nx=15)
  plot(X)
  plot(Kest(X))
}
\references{
  Baddeley, A.J. and Silverman, B.W. (1984)
  A cautionary example on the use of second-order methods for analyzing
  point patterns. \emph{Biometrics} \bold{40}, 1089-1094.
}

\author{Adrian Baddeley
  \email{adrian@maths.uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{rolf@math.unb.ca}
  \url{http://www.math.unb.ca/~rolf}
}
\keyword{spatial}
