% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_kbdm.R
\name{kbdm_sews}
\alias{kbdm_sews}
\title{Indicator based on Kolmogorov Complexity}
\usage{
kbdm_sews(mat, subsize = 3)
}
\arguments{
\item{mat}{A logical matrix (\code{TRUE}/\code{FALSE} values) or a list of logical 
matrices}

\item{subsize}{A submatrix size to carry out the Block Decomposition Method
(must be between 1 and 3)}
}
\value{
\code{kbdm_sews} returns an object of class \code{simple_sews_single} 
    (a list) if mat is a single matrix, and an object of class 
    \code{simple_sews_list} if mat is a list of matrices. These objects can 
    be used with generic methods indictest (to test significance) or plot 
    (to display trends), see also the examples below.
}
\description{
Computes the Kolmogorov Complexity on a set of matrices, 
    using the Block Decomposition Method.
}
\details{
be a useful indicator to anticipate transitions in model ecological 
    systems (Dakos and Soler-Toscano, 2017). When close to the transition 
    critical point, the complexity is expected to decrease. 
  
  The Kolmogorov complexity cannot be computed directly for large strings 
    (i.e. matrices). However, the complexity of smaller submatrices can be 
    estimated, then combined to obtain an approximation of the complexity 
    of the whole matrix. This method, the Block Decomposition Method is 
    implemented in this indicator following Dakos and Soler-Toscano (2017).
}
\examples{

\donttest{ 

kbdm_result <- kbdm_sews(serengeti, subsize = 3)
plot(kbdm_result, along = serengeti.rain)

kbdm_test <- indictest(kbdm_result, nulln = 49)
plot(kbdm_test, along = serengeti.rain)

# Plot deviation to null expectation
plot(kbdm_test, along = serengeti.rain, what = "z_score") 

}


}
\references{
Dakos, V., and F. Soler-Toscano. 2017. Measuring complexity to infer 
  changes in the dynamics of ecological systems under stress. Ecological 
  Complexity 32:144-155.
}
\seealso{
\code{\link{raw_kbdm}}, \code{\link[acss]{acss}}, 
  \code{\link{indictest}}, to test the significance of indicator values.
}
