% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_kalman_logLik.R
\name{bm_kalman_logLik}
\alias{bm_kalman_logLik}
\title{Exact log-likelihood for Brownian motion spatPomp generator}
\usage{
bm_kalman_logLik(bm_object, params = coef(bm_object))
}
\arguments{
\item{bm_object}{A spatPomp model built using \code{bm}.}

\item{params}{A parameter vector at which to evaluate the log-likelihood.
whereas observations occur every one time unit}
}
\value{
A numeric value for the log-likelihood.
}
\description{
Computes the exact likelihood for a model constructed using \code{bm},
using the Kalman filter. This model is useful for testing methods
in a situation where an exact answer is available
}
\examples{
# Further examples are provided in the tests directory
\dontrun{
b <- bm()
bm_kalman_logLik(b)
}
}
\author{
Edward L. Ionides
}
