% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatPomp.R
\name{spatPomp}
\alias{spatPomp}
\title{Constructor of the spatPomp object}
\usage{
spatPomp(
  data,
  units,
  times,
  covar,
  t0,
  ...,
  eunit_measure,
  munit_measure,
  vunit_measure,
  dunit_measure,
  runit_measure,
  rprocess,
  rmeasure,
  dprocess,
  dmeasure,
  skeleton,
  rinit,
  rprior,
  dprior,
  unit_statenames,
  unit_accumvars,
  shared_covarnames,
  globals,
  paramnames,
  params,
  cdir,
  cfile,
  shlib.args,
  PACKAGE,
  partrans,
  compile = TRUE,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a dataframe holding the spatiotemporal data,
or an object of class \sQuote{spatPomp}, i.e., the output of another \pkg{spatPomp} calculation.
If dataframe, the user must provide the name of the times column using the \code{times} argument and
the spatial unit column name using the \code{units} argument. The dataframe provided should be sorted in
increasing order of time and unit name respectively, i.e. observation 1 in unit A should come before observation
1 in unit B, which should come before observation 2 in unit A.}

\item{units}{when \code{data} is a \code{data.frame} this is the name of the column containing the spatial units.}

\item{times}{the sequence of observation times.
\code{times} must indicate the column of observation times by name or index.
The time vector must be numeric and non-decreasing.}

\item{covar}{An optional dataframe for supplying covariate information. If provided, there must be two
columns that provide the observation time and the observation spatial unit with the same names and arrangement as the \code{data}.}

\item{t0}{The zero-time, i.e., the time of the initial state.
This must be no later than the time of the first observation, i.e., \code{t0 <= times[1]}.}

\item{\dots}{If there are arguments that the user would like to pass to \pkg{pomp}'s basic constructor function's \dots argument,
this argument passes them along. Not recommended for this version of \pkg{spatPomp}.}

\item{eunit_measure}{Evaluator of the expected measurement given the latent states and model parameters. The \code{unit} variable is pre-defined, which allows the user to specify differing specifications for each unit using \code{if} conditions.
Only C snippets are accepted. The C snippet should assign the scalar approximation to the expected measurement to the pre-defined variable \code{ey} given the latent state and the parameters.
For more information, see the examples section below.}

\item{munit_measure}{Evaluator of a moment-matched parameter set (like the standard deviation parameter of a normal distribution or the size parameter of a negative binomial distribution) given an empirical variance estimate, the latent states and all model parameters.
Only Csnippets are accepted. The Csnippet should assign the scalar approximation to the measurement variance parameter to the pre-defined variable corresponding to that parameter, which has been predefined with a \code{M_} prefix. For instance, if the moment-matched parameter is \code{psi}, then the user should assign \code{M_psi} to the moment-matched value.
For more information, see the examples section below.}

\item{vunit_measure}{Evaluator of the theoretical measurement variance given the latent states and model parameters. The \code{unit} variable is pre-defined, which allows the user to specify differing specifications for each unit using \code{if} conditions.
Only C snippets are accepted. The C snippet should assign the scalar approximation to the measurement variance to the pre-defined variable \code{vc} given the latent state and the parameters.
For more information, see the examples section below.}

\item{dunit_measure}{Evaluator of the unit measurement model density given the measurement, the latent states and model parameters. The \code{unit} variable is pre-defined, which allows the user to specify differing specifications for each unit using \code{if} conditions.
Only Csnippets are accepted. The Csnippet should assign the scalar measurement density to the pre-defined variable \code{lik}. The user is encouraged to provide a logged density in an \code{if} condition that checks whether the predefined \code{give_log} variable is true.
For more information, see the examples section below.}

\item{runit_measure}{Simulator of the unit measurement model given the latent states and the model parameters.
The \code{unit} variable is pre-defined, which allows the user to specify differing specifications for each unit using \code{if} conditions.
Only Csnippets are accepted. The Csnippet should assign the scalar measurement density to the pre-defined which corresponds to the name of the observation for each unit (e.g. \code{cases} for the measles spatPomp example).
For more information, see the examples section below.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[pomp:rprocess specification]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[pomp:rprocess specification]{rprocess specification for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[pomp:rmeasure specification]{rmeasure specification}.}

\item{dprocess}{optional;
specification of the probability density evaluation function of the unobserved state process.
Setting \code{dprocess=NULL} removes the latent-state density evaluator.
For more information, see \link[pomp:dprocess specification]{dprocess specification}.}

\item{dmeasure}{evaluator of the measurement model density, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{dmeasure=NULL} removes the measurement density evaluator.
For more information, see \link[pomp:dmeasure specification]{dmeasure specification}.}

\item{skeleton}{optional; the deterministic skeleton of the unobserved state process.
Depending on whether the model operates in continuous or discrete time, this is either a vectorfield or a map.
Accordingly, this is supplied using either the \code{\link[pomp:skeleton specification]{vectorfield}} or \code{\link[pomp:skeleton specification]{map}} fnctions.
For more information, see \link[pomp:skeleton specification]{skeleton specification}.
Setting \code{skeleton=NULL} removes the deterministic skeleton.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[pomp:rinit specification]{rinit specification}.}

\item{rprior}{optional; prior distribution sampler, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
For more information, see \link[pomp:prior specification]{prior specification}.
Setting \code{rprior=NULL} removes the prior distribution sampler.}

\item{dprior}{optional; prior distribution density evaluator, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
For more information, see \link[pomp:prior specification]{prior specification}.
Setting \code{dprior=NULL} resets the prior distribution to its default, which is a flat improper prior.}

\item{unit_statenames}{The names of the components of the latent state. E.g. if the user is constructing an joint SIR model
over many spatial units, \code{c('S','I','R')} would be passed.}

\item{unit_accumvars}{a subset of the \code{unit_statenames} argument that are accumulator variables. See \link[pomp]{accumulator variables}
for more on the concept of \pkg{pomp} accumulator variables.}

\item{shared_covarnames}{If \code{covar} is supplied, covariates that are shared must still be specified for each unit, i.e.,
rows with equal values for the same time over all units must be supplied. However, if such covariates exists, supply the names
using this argument.}

\item{globals}{optional character;
arbitrary C code that will be hard-coded into the shared-object library created when  C snippets are provided.
If no C snippets are used, \code{globals} has no effect.}

\item{paramnames}{optional character vector;
names of model parameters.
It is typically only necessary to supply \code{paramnames} when C snippets are in use.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{cdir}{optional character variable.
\code{cdir} specifies the name of the directory within which C snippet code will be compiled.
By default, this is in a temporary directory specific to the \R session.
One can also set this directory using the \code{pomp_cdir} global option.}

\item{cfile}{optional character variable.
\code{cfile} gives the name of the file (in directory \code{cdir}) into which C snippet codes will be written.
By default, a random filename is used.
If the chosen filename would result in over-writing an existing file, an error is generated.}

\item{shlib.args}{optional character variables.
Command-line arguments to the \code{R CMD SHLIB} call that compiles the C snippets.}

\item{PACKAGE}{optional character;
the name (without extension) of the external, dynamically loaded library in which any native routines are to be found.
This is only useful if one or more of the model components has been specified using a precompiled dynamically loaded library;
it is not used for any component specified using C snippets.
\code{PACKAGE} can name at most one library.}

\item{partrans}{optional parameter transformations, constructed using \code{\link[pomp]{parameter_trans}}.

Many algorithms for parameter estimation search an unconstrained space of parameters.
When working with such an algorithm and a model for which the parameters are constrained, it can be useful to transform parameters.
One should supply the \code{partrans} argument via a call to \code{\link[pomp]{parameter_trans}}.
For more information, see \link[pomp:parameter_trans]{parameter_trans}.
Setting \code{partrans=NULL} removes the parameter transformations, i.e., sets them to the identity transformation.}

\item{compile}{logical;
if \code{FALSE}, compilation of the C snippets will be postponed until they are needed.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
An object of class \sQuote{spatPomp} representing observations and model components from the spatiotemporal POMP model.
}
\description{
This function constructs a class \sQuote{spatPomp} object, encoding a spatiotemporal partially observed Markov process (\acronym{SpatPOMP}) model together with a uni- or multi-variate time series on a collection of units.
Users will typically develop a POMP model for a single unit before embarking on a coupled SpatPOMP analysis.
Consequently, we assume some familiarity with \pkg{pomp} and its description by King, Nguyen and Ionides (2016).
The \code{spatPomp} class inherits from \code{pomp} with the additional unit structure being a defining feature of the resulting models and inference algorithms.
}
\details{
One implements a \acronym{SpatPOMP} model by specifying some or all of its \emph{basic components}, including:
\describe{
\item{rinit,}{the simulator from the distribution of the latent state process at the zero-time;}
\item{rprocess,}{the transition simulator of the latent state process;}
\item{dunit_measure,}{the evaluator of the conditional density at a unit's measurement given the unit's latent state;}
\item{eunit_measure,}{the evaluator of the expectation of a unit's measurement given the unit's latent state;}
\item{munit_measure,}{the evaluator of the moment-matched parameter set given a unit's latent state and some empirical measurement variance;}
\item{vunit_measure,}{the evaluator of the variance of a unit's measurement given the unit's latent state;}
\item{runit_measure,}{the simulator of a unit's measurement conditional on the unit's latent state;}
\item{dprocess,}{the evaluator of the density for transitions of the latent state process;}
\item{rmeasure,}{the simulator of the measurements conditional on the latent state;}
\item{dmeasure,}{the evaluator of the conditional density of the measurements given the latent state;}
\item{rprior,}{the simulator from a prior distribution on the parameters;}
\item{dprior,}{the evaluator of the prior density;}
\item{skeleton,}{which computes the deterministic skeleton of the unobserved state process;}
\item{partrans,}{which performs parameter transformations.}
}
The basic structure and its rationale are described in Asfaw et al. (2020).

Each basic component is supplied via an argument of the same name to \code{spatPomp()}.
The five unit-level model components must be provided via C snippets. The remaining components, whose behaviors are inherited from
\pkg{pomp} may be furnished using C snippets, \R functions, or pre-compiled native routine available in user-provided dynamically loaded libraries.
}
\references{
\asfaw2020

\king2016
}
\author{
Kidus Asfaw, Edward L. Ionides, Aaron A. King
}
