## default templates for pomp's own C snippets.
## This is used in 'spatPomp.R'.
spatPomp_workhorse_templates <- quote(list(
  vunit_measure=list(
    slotname="vunit_measure",
    Cname="__spatPomp_vunit_measure",
    proto=quote(vunit_measure(x,t,d,params,...)),
    header="\nvoid __spatPomp_vunit_measure (double *__vc, const double *__x, const double *__p, const int *__obsindex, const int *__stateindex, const int *__parindex, const int *__covindex, int __ncovars, const double *__covars, double t, int u)\n{\n",
    footer="\n}\n\n",
    vars=list(
      params=list(
        names=quote(paramnames),
        cref="__p[__parindex[{%v%}]]"
      ),
      covars=list(
        names=quote(covarnames),
        cref="__covars[__covindex[{%v%}]]"
      ),
      unit_states=list(
        names=unit_statenames,
        cref="__x[__stateindex[{%v%}]+u]"
      ),
      var=list(
        names="vc",
        cref="__vc[0]"
      )
    )
  ),
  munit_measure=list(
    slotname="munit_measure",
    Cname="__spatPomp_munit_measure",
    proto=quote(munit_measure(x,t,d,params,...)),
    header="\nvoid __spatPomp_munit_measure (double *__pm, const double *__x, const double *__p, const double *__vc, const int *__obsindex, const int *__stateindex, const int *__parindex, const int *__covindex, int __ncovars, const double *__covars, double t, int u)\n{\n",
    footer="\n}\n\n",
    vars=list(
      params=list(
        names=quote(paramnames),
        cref="__p[__parindex[{%v%}]]"
      ),
      mparams=list(
        names=mparamnames,
        cref="__pm[__parindex[{%v%}]]"
      ),
      covars=list(
        names=quote(covarnames),
        cref="__covars[__covindex[{%v%}]]"
      ),
      unit_states=list(
        names=unit_statenames,
        cref="__x[__stateindex[{%v%}]+u]"
      ),
      var=list(
        names="vc",
        cref="__vc[0]"
      )
    )
  ),
  eunit_measure=list(
    slotname="eunit_measure",
    Cname="__spatPomp_eunit_measure",
    proto=quote(eunit_measure(y,x,t,d,params,log,...)),
    header="\nvoid __spatPomp_eunit_measure (double *__ey, const double *__x, const double *__p, const int *__obsindex, const int *__stateindex, const int *__parindex, const int *__covindex, int __ncovars, const double *__covars, double t, int u)\n{\n",
    footer="\n}\n\n",
    vars=list(
      params=list(
        names=quote(paramnames),
        cref="__p[__parindex[{%v%}]]"
      ),
      covars=list(
        names=quote(covarnames),
        cref="__covars[__covindex[{%v%}]]"
      ),
      unit_states=list(
        names=unit_statenames,
        cref="__x[__stateindex[{%v%}]+u]"
      ),
      ey=list(
        names="ey",
        cref="__ey[0]"
      )
    )
  ),
  dunit_measure=list(
    slotname="dunit_measure",
    Cname="__spatPomp_dunit_measure",
    proto=quote(dunit_measure(y,x,t,d,params,log,...)),
    header="\nvoid __spatPomp_dunit_measure (double *__lik, const double *__y, const double *__x, const double *__p, int give_log, const int *__obsindex, const int *__stateindex, const int *__parindex, const int *__covindex, int __ncovars, const double *__covars, double t, int u)\n{\n",
    footer="\n}\n\n",
    vars=list(
      params=list(
        names=quote(paramnames),
        cref="__p[__parindex[{%v%}]]"
      ),
      covars=list(
        names=quote(covarnames),
        cref="__covars[__covindex[{%v%}]]"
      ),
      unit_states=list(
        names=unit_statenames,
        cref="__x[__stateindex[{%v%}]+u-1]"
      ),
      obstyp=list(
        names=unit_obsnames,
        cref="__y[__obsindex[{%v%}]+u-1]"
      ),
      lik=list(
        names="lik",
        cref="__lik[0]"
      )
    )
  ),
  runit_measure=list(
    slotname="runit_measure",
    Cname="__spatPomp_runit_measure",
    proto=quote(runit_measure(x,t,d,params,log,...)),
    header="\nvoid __spatPomp_runit_measure (const double *__y, const double *__x, const double *__p, const int *__obsindex, const int *__stateindex, const int *__parindex, const int *__covindex, int __ncovars, const double *__covars, double t, int u)\n{\n",
    footer="\n}\n\n",
    vars=list(
      params=list(
        names=quote(paramnames),
        cref="__p[__parindex[{%v%}]]"
      ),
      covars=list(
        names=quote(covarnames),
        cref="__covars[__covindex[{%v%}]]"
      ),
      unit_states=list(
        names=unit_statenames,
        cref="__x[__stateindex[{%v%}]+u-1]"
      )
    )
  )
))

