% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{ssp}
\alias{ssp}
\title{Signal space projection method for lipid suppression.}
\usage{
ssp(mrs_data, comps = 5, xlim = c(1.5, 0.8))
}
\arguments{
\item{mrs_data}{MRS data object.}

\item{comps}{the number of spatial components to use.}

\item{xlim}{spectral range (in ppm) covering the lipid signals.}
}
\value{
lipid suppressed \code{mrs_data} object.
}
\description{
Signal space projection method as described in:
Tsai SY, Lin YR, Lin HY, Lin FH. Reduction of lipid contamination in MR
spectroscopy imaging using signal space projection. Magn Reson Med 2019
Mar;81(3):1486-1498.
}
