% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_set.R
\name{scale_basis_from_singlet}
\alias{scale_basis_from_singlet}
\title{Scale a basis-set to be consistent with spant assumptions for water scaling.}
\usage{
scale_basis_from_singlet(basis, name, protons)
}
\arguments{
\item{basis}{basis set to be scaled.}

\item{name}{the name of the singlet to be used as a scaling reference.}

\item{protons}{the number of MRS visible protons contributing to the singlet
resonance.}
}
\value{
a scaled basis.
}
\description{
For correct water scaling, spant assumes the time-domain amplitude (t = 0)
for a single proton is 0.5. Internally simulated basis-sets will be correctly
scaled, however imported basis-sets should be assumed to be un-scaled and
this function should be used. Note that the singlet specified should only
contain one resonance, and that any additional signals (eg TSP or residual
water) will result in incorrect scaling. Therefore, only simulated basis sets
are appropriate for use with this function.
}
