% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{varpro_opts}
\alias{varpro_opts}
\title{Return a list of options for VARPRO based fitting.}
\usage{
varpro_opts(nstart = 10, init_g_damping = 2, maxiters = 200,
  max_shift = 5, max_g_damping = 5, max_ind_damping = 5,
  anal_jac = TRUE, bl_smth_pts = 80)
}
\arguments{
\item{nstart}{Position in the time-domain to start fitting, units of data
points.}

\item{init_g_damping}{Starting value for the global Gaussian line-broadening
term - measured in Hz.}

\item{maxiters}{Maximum number of lemar iterations to perform.}

\item{max_shift}{Maximum shift allowed to each element in the basis set,
measured in Hz.}

\item{max_g_damping}{Maximum permitted global Gaussian line-broadening.}

\item{max_ind_damping}{Maximum permitted Lorentzian line-broadening for each
element in the basis set, measured in Hz.}

\item{anal_jac}{Option to use the analytic or numerical Jacobian (logical).}

\item{bl_smth_pts}{Number of data points to use in the baseline smoothing
calculation.}
}
\value{
List of options.
}
\description{
Return a list of options for VARPRO based fitting.
}
\examples{
varpro_opts(nstart = 20)
}
