% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_heightmap.R
\name{get_heightmap}
\alias{get_heightmap}
\title{Retrieve height map from USGS national map API}
\usage{
get_heightmap(
  bbox,
  img.width = 600,
  img.height = 600,
  lat = NULL,
  lng = NULL,
  save.tif = FALSE,
  tif.filename = NULL,
  sr_bbox = 4326,
  sr_image = 4326,
  verbose = FALSE
)
}
\arguments{
\item{bbox}{Bounding box to download imagery for}

\item{img.width}{Image width, in pixels}

\item{img.height}{Image size, in pixels}

\item{lat}{A quoted string indicating what named value in the bounding box
represents latitude. If NULL, will be inferred from bounding box names.}

\item{lng}{A quoted string indicating what named value in the bounding box
represents longitude. If NULL, will be inferred from bounding box names.}

\item{save.tif}{Logical: should the downloaded imagery be saved as a file?}

\item{tif.filename}{If \code{save.tif} is \code{TRUE}, the filepath to save the
resulting .tif to.}

\item{sr_bbox}{Spatial reference code (ISO 19111) for bounding box}

\item{sr_image}{Spatial reference code (ISO 19111) for image}

\item{verbose}{Logical: print out debug information while trying to query the
elevation map server?}
}
\value{
A matrix object containing elevation data suitable for use with
mapping functions. Returned invisibly.
}
\description{
This function retrieves elevation data from the USGS national map API and
converts it into a matrix appropriate for further usage with tools such as
rayshader. It requires a functioning internet connection to retrieve data.
}
\examples{
\dontrun{
bbox <- get_centroid_bounding_box(c(
  "lat" = 44.121268,
  "lng" = -73.903734
),
distance = 10
)

heightmap <- get_heightmap(bbox)
}

}
