%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.qq}

\alias{plot.qq}

\title{ Histogram and Normal Quantile-Quantile plot}

\description{Produces a histogram and a normal Quantile-Quantile plot
of the data. The points corresponding to genes with statistics
less/greater than a user defined threshold are highlighted. The
histogram and Q-Q plots are displayed on the same page. 
}

\usage{
plot.qq(x, name, low=-5, high=5)
}

\arguments{

 \item{x}{a numeric vector containing the statistics whose histogram
 and Q-Q plot will be produced. Missing values (NAs) are allowed.}

 \item{name}{title for the plots.}

 \item{low}{lower threshold: points with statistic < low are colored
 in green.}

 \item{high}{upper threshold: points with statistic > high are
 colored in red.} 
} 

\references{Chambers, J. M., Cleveland, W. S., Kleiner, B. and
Tukey, P. A. (1983). Graphical Methods for Data Analysis. Wadsworth,
Belmont, California. 
 
Hoaglin, D. C., Mosteller, F. and Tukey, J.  W., editors
 (1983). Understanding Robust and Exploratory Data Analysis. Wiley,
 New York.         
}

\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} 
}

\seealso{\code{\link{plot.spatial}}, \code{\link{plot.t2}},
\code{\link{stat.t2}}, \code{\link{hist}}, \code{\link{qqnorm}}.} 

\examples{
data(MouseArray)
## mouse.setup <- init.grid()
## mouse.data <- init.data() ## see \emph{init.data}
## mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Calculation of t-statistics
## cl <- c(rep(1,3), rep(2,3))
## mouse.t2 <- stat.t2(mouse.lratio, cl)

## Diagnostic plots
plot.qq(mouse.t2$t, "Mouse")
}     

\keyword{microarray, histogram, qqplot.}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
