% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/li_yao.R
\name{li_yao}
\alias{li_yao}
\title{Li-Yao ALRT and CVT Tests for Heteroskedasticity in a Linear Regression Model}
\usage{
li_yao(mainlm, method = c("cvt", "alrt"), baipanyin = TRUE, statonly = FALSE)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{method}{A character indicating which of the two tests derived in
\insertCite{Li19;textual}{skedastic} should be implemented. Possible
values are \code{"alrt"} (approximate likelihood-ratio test) and
\code{"cvt"} (coefficient-of-variation test). Default is \code{"cvt"}.
Partial matching is used.}

\item{baipanyin}{A logical. Should the central limit theorem of
\insertCite{Bai16;textual}{skedastic} be used to determine the
\eqn{p}-value for the coefficient-of-variation test (assuming normally
distributed errors)? If \code{FALSE}, the asymptotic null distribution
in \insertCite{Li19;textual}{skedastic} is used, which requires the
assumption that the design variables are random and normally distributed.
This argument is ignored if \code{method} is \code{"alrt"}.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the two methods of
   \insertCite{Li19;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
These two tests are straightforward to implement; in both cases the
   test statistic is a function only of the residuals of the linear
   regression model. Furthermore, in both cases the test statistic is
   asymptotically normally distributed under the null hypothesis of
   homoskedasticity. Both tests are right-tailed. These tests are designed
   to be especially powerful in high-dimensional regressions, i.e. when the
   number of explanatory variables is large.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
li_yao(mtcars_lm, method = "alrt")
li_yao(mtcars_lm, method = "cvt")
li_yao(mtcars_lm, method = "cvt", baipanyin = FALSE)
# Same as first example
li_yao(list("e" = mtcars_lm$residuals), method = "alrt")

}
\references{
{\insertAllCited{}}
}
