% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.raster_cube}
\alias{plot.raster_cube}
\title{Plot RGB data cubes}
\usage{
\method{plot}{raster_cube}(
  x,
  ...,
  band = NULL,
  red = NULL,
  green = NULL,
  blue = NULL,
  tile = x$tile[[1]],
  date = NULL,
  segments = NULL,
  seg_color = "lightgoldenrod",
  palette = "RdYlGn",
  rev = FALSE,
  tmap_options = NULL
)
}
\arguments{
\item{x}{Object of class "raster_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{band}{Band for plotting grey images.}

\item{red}{Band for red color.}

\item{green}{Band for green color.}

\item{blue}{Band for blue color.}

\item{tile}{Tile to be plotted.}

\item{date}{Date to be plotted.}

\item{segments}{List with segments to be shown (one per tile)}

\item{seg_color}{Color to use for segment borders}

\item{palette}{An RColorBrewer palette}

\item{rev}{Reverse the color order in the palette?}

\item{tmap_options}{List with optional tmap parameters
tmap_max_cells (default: 1e+06)
tmap_graticules_labels_size (default: 0.7)
tmap_legend_title_size (default: 1.5)
tmap_legend_text_size (default: 1.2)
tmap_legend_bg_color (default: "white")
tmap_legend_bg_alpha (default: 0.5)}
}
\value{
A plot object with an RGB image
                      or a B/W image on a color
                      scale using the pallete
}
\description{
Plot RGB raster cube
}
\note{
To see which color palettes are supported, please run
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # plot NDVI band of the second date date of the data cube
    plot(cube, band = "NDVI", date = sits_timeline(cube)[2])
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
