% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_apply.R
\name{sits_apply}
\alias{sits_apply}
\alias{sits_apply.sits}
\alias{sits_apply.raster_cube}
\alias{.apply_across}
\title{Apply a function on a set of time series}
\usage{
sits_apply(data, ...)

\method{sits_apply}{sits}(data, ...)

\method{sits_apply}{raster_cube}(
  data,
  ...,
  memsize = 1,
  multicores = 2,
  output_dir = getwd(),
  progress = TRUE
)

.apply_across(data, fn, ...)
}
\arguments{
\item{data}{Valid sits tibble or cube}

\item{...}{Named expressions to be evaluated.}

\item{memsize}{Memory available for classification (in GB).}

\item{multicores}{Number of cores to be used for classification.}

\item{output_dir}{Directory where files will be saved.}
}
\value{
A sits tibble or a sits cube with new bands, produced
        according to the requested expression.
}
\description{
Apply a named expression to a sits cube or a sits tibble
to be evaluated and generate new bands (indices). In the case of sits
cubes, it materializes a new band in `output_dir` using `gdalcubes`.
}
\examples{
# Get a time series
# Apply a normalization function

point2 <-
    sits_select(point_mt_6bands, "NDVI") \%>\%
    sits_apply(NDVI_norm = (NDVI - min(NDVI)) / (max(NDVI) - min(NDVI)))
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
