% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_filters.R
\name{.sits_signal_sgolay}
\alias{.sits_signal_sgolay}
\title{Savitzky-Golay smoothing filter coefficients}
\usage{
.sits_signal_sgolay(p, n, m = 0, ts = 1)
}
\arguments{
\item{p}{Filter order (integer).}

\item{n}{Filter length (must be odd)}

\item{m}{Derivative to calculate (default = 0)}

\item{ts}{Time scaling (integer).}
}
\value{
filter coefficients
}
\description{
Computes the filter coefficients for all Savitzky-Golay
smoothing filters of order p for length n (odd). m can be used in order to
get directly the mth derivative. In this case, ts is a scaling factor.

The early rows of F smooth based on future values and later rows
smooth based on past values, with the middle row using half future
and half past.  In particular, you can use row i to estimate x(k)
based on the i-1 preceding values and the n-i following values of x
values as y(k) = F(i,:) * x(k-i+1:k+n-i).
}
\keyword{internal}
