% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfset.R
\name{dfset}
\alias{dfset}
\title{Find degrees of freedom for a natural spline curve to minimise BIC or AIC}
\usage{
dfset(x, y, data = parent.frame(), FUN = BIC, df = 1:15, plot = FALSE,
  ...)
}
\arguments{
\item{x}{vector of x coordinates.}

\item{y}{vector of y coordinates.}

\item{data}{data frame containing \code{x} and \code{y}.}

\item{FUN}{function to be minimised (e.g. BIC or AIC).}

\item{df}{vector of degrees of freedom to be searched.}

\item{plot}{logical controlling plotting of FUN versus df.}

\item{\dots}{parameters to pass to \code{plot}.}
}
\value{
Optimal degrees of freedom.
}
\description{
\code{dfset} fits a natural cubic spline for a range
of degrees of freedom, and returns the df minimising the BIC or AIC.
}
\examples{
data(heights)
dfset(age, height, heights, FUN=BIC, plot=TRUE)
dfset(age, height, heights, FUN=function(a) AIC(a, k=1))
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
