% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importSurferGrd.R
\name{importSurferGrd}
\alias{importSurferGrd}
\title{Import Grid file}
\usage{
importSurferGrd(fname, k = 1000, destaggering = FALSE)
}
\arguments{
\item{fname}{Surfer grd file to be imported}

\item{k}{Factor to apply to x and y coordinates}

\item{destaggering}{Boolean variable to apply or not destaggering.}
}
\value{
A dataset with x, y and z columns is returned.
}
\description{
A function to import data from Surfer text grid file.
}
\details{
Surfer grd file is imported and an array of x, y, z columns is returned
X and y coordinates can be converted from km to m (default k=1000)
and vice versa. Destaggering is applied by default.
}
\examples{
\dontrun{
# Import Surfer Grd file and convert coordinates from km to m, 
# with destaggering
mydata <- importSurferGrd("/path_to_file/filename.grd", k = 1000)

# Import Surfer Grd file and do not convert coordinates, without
#  destaggering
mydata <- importSurferGrd("path_to_file/filename.grd", k = 1,
                          destaggering = FALSE)
}
}
\seealso{
\code{\link[=importRaster]{importRaster()}}, \code{\link[=importADSOBIN]{importADSOBIN()}}
}
