% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{create_trajectory}
\alias{create_trajectory}
\title{Create a trajectory}
\usage{
create_trajectory(name = "anonymous", verbose = FALSE)
}
\arguments{
\item{name}{the name of the trajectory.}

\item{verbose}{enable showing additional information.}
}
\value{
Returns an environment that represents the trajectory.
}
\description{
This method initialises a trajectory object, which comprises a chain of
activities that can be attached to a generator.
}
\examples{
t0 <- create_trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)

t0

t1 <- create_trajectory("trajectory with a branch") \%>\%
  seize("server", 1) \%>\%
  # 50-50 chance for each branch
  branch(function() sample(1:2, 1), continue=c(TRUE, FALSE),
    create_trajectory("branch1") \%>\%
      timeout(function() 1),
    create_trajectory("branch2") \%>\%
      timeout(function() rexp(1, 3)) \%>\%
      release("server", 1)
  ) \%>\%
  # only the first branch continues here
  release("server", 1) \%>\%
  timeout(function() 2)

t1
}
\seealso{
Methods for dealing with trajectories:
\code{\link{get_head}}, \code{\link{get_tail}}, \code{\link{get_n_activities}}, \code{\link{join}},
\code{\link{seize}}, \code{\link{release}}, \code{\link{seize_selected}}, \code{\link{release_selected}},
\code{\link{select}}, \code{\link{set_capacity}}, \code{\link{set_queue_size}},
\code{\link{set_capacity_selected}}, \code{\link{set_queue_size_selected}}, \code{\link{set_prioritization}},
\code{\link{activate}}, \code{\link{deactivate}}, \code{\link{set_trajectory}},
\code{\link{set_distribution}}, \code{\link{set_attribute}}, \code{\link{timeout}}, \code{\link{branch}},
\code{\link{rollback}}, \code{\link{leave}}, \code{\link{renege_in}}, \code{\link{renege_abort}},
\code{\link{clone}}, \code{\link{synchronize}}, \code{\link{batch}}, \code{\link{separate}},
\code{\link{send}}, \code{\link{trap}}, \code{\link{untrap}}, \code{\link{wait}}, \code{\link{log_}}.
}

