% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSqTest.R
\name{wrapChiSqTest.data.frame}
\alias{wrapChiSqTest.data.frame}
\title{Format ChiSqTest from data.}
\usage{
\method{wrapChiSqTest}{data.frame}(x, predictionColumnName, yColumnName,
  nParameters = 1, meany = mean(x[[yColumnName]]), ...)
}
\arguments{
\item{x}{data frame containing columns to compare}

\item{predictionColumnName}{character name of prediction column}

\item{yColumnName}{character name of column containing dependent variable}

\item{nParameters}{number of variables in model}

\item{meany}{(optional) mean of y}

\item{...}{extra arguments (not used)}
}
\value{
wrapped test
}
\description{
Format ChiSqTest from data.
}
\examples{

d <- data.frame(x=c(1,2,3,4,5,6,7,7),
      y=c(TRUE,FALSE,FALSE,FALSE,TRUE,TRUE,TRUE,FALSE))
model <- glm(y~x,data=d,family=binomial)
summary(model)
d$pred <- predict(model,type='response',newdata=d)
render(wrapChiSqTest(d,'pred','y'),pLargeCutoff=1)

}
