% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-material-card.R
\name{material_card}
\alias{material_card}
\title{Create a card that will contain UI content}
\usage{
material_card(title, ..., depth = NULL, color = NULL, divider = FALSE)
}
\arguments{
\item{title}{String. The title of the card}

\item{...}{The UI elements to place in the card}

\item{depth}{Integer. The amount of depth of the card. The value should be between 0 and 5. Leave empty for the default depth.}

\item{color}{String. The color of the card background. Leave empty for the default color. Visit \url{http://materializecss.com/color.html} for a list of available colors.}

\item{divider}{logical. Should there be a divider element between card title and card content?}
}
\description{
UI content can be placed in cards to organize items on a page.
}
\examples{
material_card(
  title = "Example Card",
  depth = 5,
  shiny::tags$h5("Card Content")
)
}
