% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colourInput.R
\name{updateColourInput}
\alias{updateColourInput}
\title{Change the value of a colour input}
\usage{
updateColourInput(session, inputId, label = NULL, value = NULL,
  showColour = NULL, palette = NULL, allowedCols = NULL,
  allowTransparent = NULL, transparentText = NULL, returnName = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{inputId}{The id of the colour input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{showColour}{Whether to shoW the chosen colour via text, background, or both.}

\item{palette}{The type of colour palette to allow the user to select colours
from.}

\item{allowedCols}{A list of colours that the user can choose from.}

\item{allowTransparent}{If \code{TRUE}, then add a checkbox that allows the
user to select the \code{transparent} colour.}

\item{transparentText}{The text to show beside the transparency checkbox
when \code{allowTransparent} is \code{TRUE}}

\item{returnName}{If \code{TRUE}, then return the name of an R colour instead
of a HEX value when possible.}
}
\description{
Change the value of a colour input on the client.
}
\details{
The update function sends a message to the client, telling it to change
the settings of a colour input object.\cr
This function works similarly to the update functions provided by shiny.\cr
Any argument with \code{NULL} values will be ignored.
}
\note{
Unlike the rest of the \code{shinyjs} functions, this function does
not require you to call \code{useShinyjs()} first.

See \href{http://daattali.com/shiny/colourInput/}{http://daattali.com/shiny/colourInput/}
for a live demo.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      div("Selected colour:", textOutput("value", inline = TRUE)),
      colourInput("col", "Choose colour", "red"),
      h3("Update colour input"),
      textInput("text", "New colour: (colour name or HEX value)"),
      selectInput("showColour", "Show colour",
        c("both", "text", "background")),
      checkboxInput("allowTransparent", "Allow transparent", FALSE),
      checkboxInput("returnName", "Return R colour name", FALSE),
      actionButton("btn", "Update")
    ),
    server = function(input, output, session) {
      observeEvent(input$btn, {
        updateColourInput(session, "col",
          value = input$text, showColour = input$showColour,
          allowTransparent = input$allowTransparent,
          returnName = input$returnName)
      })
      output$value <- renderText(input$col)
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{colourInput}}
}

