% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{userMessages}
\alias{userMessages}
\title{AdminLTE2 user message container}
\usage{
userMessages(..., status, width = 4)
}
\arguments{
\item{...}{Slot for \link{userMessage}.}

\item{status}{Messages status. See here for a list of valid colors 
\url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{width}{Container width: between 1 and 12.}
}
\description{
Create a user message container
}
\note{
Better to include in a \link{boxPlus}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
  ui = dashboardPagePlus(
    dashboardHeaderPlus(),
    dashboardSidebar(),
    dashboardBody(
     boxPlus(
      "Box with messages",
      solidheader = TRUE,
      status = "warning",
      userMessages(
       width = 12,
       status = "success",
        userMessage(
         author = "Alexander Pierce",
         date = "20 Jan 2:00 pm",
         src = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
         side = NULL,
         "Is this template really for free? That's unbelievable!"
       ),
       userMessage(
         author = "Sarah Bullock",
         date = "23 Jan 2:05 pm",
         src = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
         side = "right",
         "You better believe it!"
       )
      )
     ),
     userMessages(
       width = 6,
       status = "danger",
        userMessage(
         author = "Alexander Pierce",
         date = "20 Jan 2:00 pm",
         src = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
         side = NULL,
         "Is this template really for free? That's unbelievable!"
       ),
       userMessage(
         author = "Sarah Bullock",
         date = "23 Jan 2:05 pm",
         src = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
         side = "right",
         "You better believe it!"
       )
      )
    ),
    title = "user Message"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
