% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rightSidebar.R
\name{rightSidebar}
\alias{rightSidebar}
\title{AdminLTE2 dashboard right sidebar}
\usage{
rightSidebar(..., background = "dark", width = 230, .items = NULL)
}
\arguments{
\item{...}{slot for rightSidebarTabContent. Not compatible with .items.}

\item{background}{background color: "dark" or "light".}

\item{width}{Sidebar width in pixels. Numeric value expected. 230 by default.}

\item{.items}{Pass element here if you do not want to embed them in panels. Not compatible with ...}
}
\description{
This creates a right sidebar.
}
\note{
Until a maximum of 5 rightSidebarTabContent inside! AdminLTE 2 does not
support more panels.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
   ui = dashboardPagePlus(
     header = dashboardHeaderPlus(
      enable_rightsidebar = TRUE,
      rightSidebarIcon = "gears"
     ),
     sidebar = dashboardSidebar(),
     body = dashboardBody(),
     rightsidebar = rightSidebar(
      background = "dark",
       rightSidebarTabContent(
        id = 1,
        icon = "desktop",
        title = "Tab 1",
        active = TRUE,
        sliderInput(
         "obs", 
         "Number of observations:",
          min = 0, max = 1000, value = 500
         )
       ),
       rightSidebarTabContent(
        id = 2,
        title = "Tab 2",
        textInput("caption", "Caption", "Data Summary")
       ),
       rightSidebarTabContent(
        id = 3,
        title = "Tab 3",
        icon = "paint-brush",
        numericInput("obs", "Observations:", 10, min = 1, max = 100)
       )
     ),
     title = "Right Sidebar"
   ),
   server = function(input, output) { }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
