% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Card.R
\name{f7Card}
\alias{f7Card}
\alias{f7ExpandableCard}
\alias{updateF7Card}
\title{Framework7 card}
\usage{
f7Card(
  ...,
  image = NULL,
  title = NULL,
  footer = NULL,
  outline = FALSE,
  height = NULL,
  raised = FALSE,
  divider = FALSE
)

f7ExpandableCard(
  ...,
  id = NULL,
  title = NULL,
  subtitle = NULL,
  color = NULL,
  image = NULL,
  fullBackground = FALSE,
  buttonColor = "white"
)

updateF7Card(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{Card content.}

\item{image}{Card background image url. Tje JPG format is prefered. Not compatible
with the color argument.}

\item{title}{Card title.}

\item{footer}{Footer content, if any. Must be wrapped in a tagList.}

\item{outline}{Outline style. FALSE by default.}

\item{height}{Card height. NULL by default.}

\item{raised}{Card shadow. FALSE by default.}

\item{divider}{Card header/footer dividers. FALSE by default.}

\item{id}{Card id.}

\item{subtitle}{Card subtitle.}

\item{color}{Card background color. See \url{https://framework7.io/docs/cards.html}.
Not compatible with the img argument.}

\item{fullBackground}{Whether the image should cover the entire card.}

\item{buttonColor}{Color of the close button. Default is "white".}

\item{session}{Shiny session object.}
}
\description{
\code{f7Card} creates a simple card container.

\code{f7ExpandableCard} is a card that can expand. Ideal for a
gallery.

\code{updateF7Card} maximizes an \link{f7ExpandableCard} on the client.
}
\note{
For \link{f7ExpandableCard}, image and color are not compatible. Choose one of them.
}
\examples{
# Simple card
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  shinyApp(
    ui = f7Page(
      title = "Cards",
      options = list(dark = FALSE),
      f7SingleLayout(
        navbar = f7Navbar(title = "f7Card"),
        f7Card("This is a simple card with plain text,
      but cards can also contain their own header,
      footer, list view, image, or any other element."),
        f7Card(
          title = "Card header",
          raised = TRUE,
          outline = TRUE,
          divider = TRUE,
          div(class = "date", "March 16, 2024"),
          "This is a simple card with plain text,
       but cards can also contain their own header,
       footer, list view, image, or any other element.",
          footer = "Card footer"
        ),
        f7Card(
          title = "Card header",
          image = "https://cdn.framework7.io/placeholder/nature-1000x600-3.jpg",
          "This is a simple card with plain text,
       but cards can also contain their own header,
       footer, list view, image, or any other element.",
          footer = tagList(
            f7Link("Link 1", href = "https://google.com"),
            f7Badge("Badge", color = "green")
          )
        )
      )
    ),
    server = function(input, output) {}
  )
}

library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Expandable Cards",
    f7SingleLayout(
      navbar = f7Navbar(title = "Expandable Cards"),
      f7ExpandableCard(
        id = "card1",
        title = "Expandable Card 1",
        image = "https://i.pinimg.com/originals/73/38/6e/73386e0513d4c02a4fbb814cadfba655.jpg",
        "Framework7 - is a free and open source HTML mobile framework
         to develop hybrid mobile apps or web apps with iOS or Android
         native look and feel. It is also an indispensable prototyping apps tool
         to show working app prototype as soon as possible in case you need to."
      ),
      hr(),
      f7BlockTitle(title = "Click below to expand the card!") \%>\% f7Align(side = "center"),
      f7Button(inputId = "go", label = "Go"),
      br(),
      f7ExpandableCard(
        id = "card2",
        title = "Expandable Card 2",
        fullBackground = TRUE,
        image = "https://cdn.pixabay.com/photo/2017/10/03/18/55/mountain-2813667_960_720.png",
        "Framework7 - is a free and open source HTML mobile framework
        to develop hybrid mobile apps or web apps with iOS or Android
        native look and feel. It is also an indispensable prototyping apps tool
        to show working app prototype as soon as possible in case you need to."
      )
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$go, {
      updateF7Card(id = "card2")
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
