% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Swiper.R
\name{f7Swiper}
\alias{f7Swiper}
\alias{f7Slide}
\title{Framework7 swiper}
\usage{
f7Swiper(
  ...,
  id,
  options = list(speed = 400, loop = FALSE, spaceBetween = 50, slidesPerView = "auto",
    centeredSlides = TRUE, navigation = list(nextEl = ".swiper-button-next", prevEl =
    ".swiper-button-prev"), pagination = list(el = ".swiper-pagination", clickable =
    TRUE), scrollbar = list(el = ".swiper-scrollbar", draggable = TRUE))
)

f7Slide(...)
}
\arguments{
\item{...}{Slide content. Any element.}

\item{id}{Swiper unique id.}

\item{options}{Other options. Expect a list.
See \url{https://swiperjs.com/swiper-api} for all available options.}
}
\description{
\code{f7Swiper} creates a Framework7 swiper container (like carousel).

\code{f7Slide} is an \link{f7Swiper} element.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shiny::shinyApp(
  ui = f7Page(
    title = "Swiper",
    f7SingleLayout(
      navbar = f7Navbar(title = "f7Swiper"),
      f7Swiper(
        id = "swiper",
        f7Slide(
          f7Card(
            f7Toggle(
              inputId = "toggle",
              label = "My toggle",
              color = "pink",
              checked = TRUE
            ),
            verbatimTextOutput("test")
          )
        ),
        f7Slide(
          f7Card(
            f7Slider(
              inputId = "slider",
              label = "Number of observations",
              max = 1000,
              min = 0,
              value = 100,
              scaleSteps = 5,
              scaleSubSteps = 3,
              scale = TRUE,
              color = "orange",
              labels = tagList(
                f7Icon("circle"),
                f7Icon("circle_fill")
              )
            ),
            textOutput("test2")
          ),
        )
      )
    )
  ),
  server = function(input, output) {
    output$test <- renderPrint(input$toggle)
    output$test2 <- renderText(input$slider)
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
