% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Icon.R
\name{f7Icon}
\alias{f7Icon}
\title{Framework7 icons}
\usage{
f7Icon(..., lib = NULL, color = NULL, style = NULL)
}
\arguments{
\item{...}{Icon name and \link{f7Badge}.}

\item{lib}{Library to use: NULL, "ios" or "md".
Leave \code{NULL} by default. Specify, md or ios
if you want to hide/show icons on specific devices. If you choose
"md" be sure to include the corresponding fonts
as they are not provided by shinyMobile. You can get them
at \url{https://github.com/marella/material-icons/}.}

\item{color}{Icon color, if any.}

\item{style}{CSS styles to be applied on icon, for example
use \code{font-size: 56px;} to have a bigger icon.}
}
\description{
Use Framework7 icons in shiny applications,
see complete list of icons here : \url{https://framework7.io/icons/}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  shinyApp(
    ui = f7Page(
      title = "Icons",
      f7SingleLayout(
        navbar = f7Navbar(title = "icons"),
        f7List(
          f7ListItem(
            title = tagList(
              f7Icon("envelope")
            )
          ),
          f7ListItem(
            title = tagList(
              f7Icon("envelope_fill", color = "green")
            )
          ),
          f7ListItem(
            title = f7Icon("house", f7Badge("1", color = "red"))
          ),
          f7ListItem(
            title = f7Icon("home", lib = "md"),
            "Only for material design"
          )
        )
      )
    ),
    server = function(input, output) {}
  )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
