% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{split_layout}
\alias{split_layout}
\alias{splitLayout}
\title{Split layout}
\usage{
split_layout(..., cell_widths = NULL, cell_args = "", style = NULL)

splitLayout(..., cellWidths = NULL, cellArgs = "", style = NULL)
}
\arguments{
\item{...}{Unnamed arguments will become child elements of the layout.}

\item{cell_widths}{Character or numeric vector indicating the widths of the
individual cells. Recycling will be used if needed.}

\item{cell_args}{character with additional attributes that should be used for
each cell of the layout.}

\item{style}{character with style of outer box surrounding all elements}

\item{cellWidths}{same as \code{cell_widths}}

\item{cellArgs}{same as \code{cell_args}}
}
\value{
split layout grid object
}
\description{
Lays out elements horizontally, dividing the available horizontal space into
equal parts (by default) or specified by parameters.
}
\examples{
if (interactive()) {
  #' Server code used for all examples
  server <- function(input, output) {
    output$plot1 <- renderPlot(plot(cars))
    output$plot2 <- renderPlot(plot(pressure))
    output$plot3 <- renderPlot(plot(AirPassengers))
  }
  #' Equal sizing
  ui <- semanticPage(
    split_layout(
      plotOutput("plot1"),
      plotOutput("plot2")
    )
  )
  shinyApp(ui, server)
  #' Custom widths
  ui <- semanticPage(
    split_layout(cell_widths = c("25\%", "75\%"),
                plotOutput("plot1"),
                plotOutput("plot2")
    )
  )
  shinyApp(ui, server)
  #' All cells at 300 pixels wide, with cell padding
  #' and a border around everything
  ui <- semanticPage(
    split_layout(
    cell_widths = 300,
    cell_args = "padding: 6px;",
    style = "border: 1px solid silver;",
    plotOutput("plot1"),
    plotOutput("plot2"),
    plotOutput("plot3")
  )
  )
  shinyApp(ui, server)
}
}
