% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_pattern.R
\name{reconstruct_pattern}
\alias{reconstruct_pattern}
\title{reconstruct_pattern}
\usage{
reconstruct_pattern(
  pattern,
  method = "homo",
  n_random = 1,
  e_threshold = 0.01,
  max_runs = 1000,
  no_change = Inf,
  annealing = 0.01,
  comp_fast = 1000,
  n_points = NULL,
  window = NULL,
  weights = c(0.5, 0.5),
  r_length = 250,
  r_max = NULL,
  return_input = TRUE,
  simplify = FALSE,
  verbose = TRUE,
  plot = FALSE
)
}
\arguments{
\item{pattern}{ppp object with pattern.}

\item{method}{Character with specifying the method. Either \code{"homo"},
\code{"cluster"} or \code{"hetero"}.}

\item{n_random}{Integer with number of randomizations.}

\item{e_threshold}{Double with minimum energy to stop reconstruction.}

\item{max_runs}{Integer with maximum number of iterations if \code{e_threshold}
is not reached.}

\item{no_change}{Integer with number of iterations at which the reconstruction will
stop if the energy does not decrease.}

\item{annealing}{Double with probability to keep relocated point even if energy
did not decrease.}

\item{comp_fast}{Integer with threshold at which summary functions are estimated
in a computational fast way.}

\item{n_points}{Integer with number of points to be simulated.}

\item{window}{owin object with window of simulated pattern.}

\item{weights}{Vector with weights used to calculate energy.
The first number refers to Gest(r), the second number to pcf(r).}

\item{r_length}{Integer with number of intervals from \code{r=0} to \code{r=rmax} for which
the summary functions are evaluated.}

\item{r_max}{Double with maximum distance used during calculation of summary functions. If \code{NULL},
will be estimated from data.}

\item{return_input}{Logical if the original input data is returned.}

\item{simplify}{Logical if only pattern will be returned if \code{n_random=1}
and \code{return_input=FALSE}.}

\item{verbose}{Logical if progress report is printed.}

\item{plot}{Logical if pcf(r) function is plotted and updated during optimization.}
}
\value{
rd_pat
}
\description{
Pattern reconstruction
}
\details{
The functions randomizes the observed pattern by using pattern reconstruction
as described in Tscheschel & Stoyan (2006) and Wiegand & Moloney (2014). The
algorithm shifts a point to a new location and keeps the change only, if the
deviation between the observed and the reconstructed pattern decreases.
The pair correlation function and the nearest neighbour distance function are
used to describe the patterns.

For large patterns (\code{n > comp_fast}) the pair correlation function can be estimated
from Ripley's K-function without edge correction. This decreases the computational
time. For more information see \code{\link{estimate_pcf_fast}}.

The reconstruction can be stopped automatically if for n steps the energy does not
decrease. The number of steps can be controlled by \code{no_change} and is set to
\code{no_change = Inf} as default to never stop automatically.

The weights must be 0 < sum(weights) <= 1. To weight both summary functions identical,
use \code{weights = c(0.5, 0.5)}.

\code{spatstat} sets \code{r_length} to 513 by default. However, a lower value decreases
the computational time, while increasing the "bumpiness" of the summary function.

The arguments \code{n_points} and \code{window} are used for \code{method="homo"} only.

\subsection{method="homo":}{
The algorithm starts with a random pattern.
}

\subsection{method="cluster":}{
The algorithm starts with a random but clustered pattern.
}

\subsection{method="hetero":}{
The algorithm starts with a random but heterogeneous pattern.
}
}
\examples{
\dontrun{
pattern_recon <- reconstruct_pattern(species_b, n_random = 19, max_runs = 1000)
}

}
\references{
Kirkpatrick, S., Gelatt, C.D.Jr., Vecchi, M.P., 1983. Optimization by simulated
annealing. Science 220, 671–680. <https://doi.org/10.1126/science.220.4598.671>

Tscheschel, A., Stoyan, D., 2006. Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis 51, 859–871.
<https://doi.org/10.1016/j.csda.2005.09.007>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton. ISBN 978-1-4200-8254-8
}
\seealso{
\code{\link{calculate_energy}} \cr
\code{\link{reconstruct_pattern_marks}}
}
