% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_pattern_homo.R
\name{reconstruct_pattern_homo}
\alias{reconstruct_pattern_homo}
\title{reconstruct_pattern_homo}
\usage{
reconstruct_pattern_homo(
  pattern,
  n_random = 1,
  e_threshold = 0.01,
  max_runs = 1000,
  no_change = Inf,
  annealing = 0.01,
  n_points = NULL,
  window = NULL,
  comp_fast = 1000,
  weights = c(0.5, 0.5),
  r_length = 250,
  return_input = TRUE,
  simplify = FALSE,
  verbose = TRUE,
  plot = FALSE
)
}
\arguments{
\item{pattern}{ppp object with pattern.}

\item{n_random}{Integer with number of randomizations.}

\item{e_threshold}{Double with minimum energy to stop reconstruction.}

\item{max_runs}{Integer with maximum number of iterations if \code{e_threshold}
is not reached.}

\item{no_change}{Integer with number of iterations at which the reconstruction will
stop if the energy does not decrease.}

\item{annealing}{Double with probability to keep relocated point even if energy
did not decrease.}

\item{n_points}{Integer with number of points to be simulated.}

\item{window}{owin object with window of simulated pattern.}

\item{comp_fast}{Integer with threshold at which summary functions are estimated
in a computational fast way.}

\item{weights}{Vector with weights used to calculate energy.
The first number refers to Gest(r), the second number to pcf(r).}

\item{r_length}{Integer with number of intervals from \code{r = 0} to \code{r = rmax} for which
the summary functions are evaluated.}

\item{return_input}{Logical if the original input data is returned.}

\item{simplify}{Logical if only pattern will be returned if \code{n_random = 1}
and \code{return_input = FALSE}.}

\item{verbose}{Logical if progress report is printed.}

\item{plot}{Logical if pcf(r) function is plotted and updated during optimization.}
}
\value{
rd_pat
}
\description{
Pattern reconstruction for homogeneous pattern
}
\examples{
\dontrun{
pattern_recon_a <- reconstruct_pattern_homo(species_a, n_random = 19,
max_runs = 1000)

pattern_recon_b <- reconstruct_pattern_homo(species_a, n_points = 70,
n_random = 19, max_runs = 1000)
}

}
\references{
Kirkpatrick, S., Gelatt, C.D.Jr., Vecchi, M.P., 1983. Optimization by simulated
annealing. Science 220, 671–680. <https://doi.org/10.1126/science.220.4598.671>

Tscheschel, A., Stoyan, D., 2006. Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis 51, 859–871.
<https://doi.org/10.1016/j.csda.2005.09.007>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton. ISBN 978-1-4200-8254-8
}
\keyword{internal}
