/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.sdols.clustering;

import java.io.Serializable;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.sdols.CrossCompatibility$;
import org.ddahl.sdols.clustering.Cluster;
import org.ddahl.sdols.clustering.Cluster$;
import org.ddahl.sdols.clustering.Clustering;
import org.ddahl.sdols.clustering.Clustering$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.parallel.immutable.ParVector$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.math.Ordering$Double$TotalOrdering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public final class ClusteringSummary$ {
    public static final ClusteringSummary$ MODULE$ = new ClusteringSummary$();
    private static final Ordering$Double$TotalOrdering$ ordering = CrossCompatibility$.MODULE$.doubleOrdering();
    private static final Tuple2<Cluster<Null$>, Object> emptyTuple = new Tuple2(Cluster$.MODULE$.empty(null), (Object)BoxesRunTime.boxToDouble((double)0.0));

    public Ordering$Double$TotalOrdering$ ordering() {
        return ordering;
    }

    public <A> double[][] expectedPairwiseAllocationMatrix(Seq<Clustering<A>> clusterings) {
        int nItems = ((Clustering)clusterings.apply(0)).nItems();
        int[][] x = (int[][])Array$.MODULE$.ofDim(nItems, nItems, (ClassTag)ClassTag$.MODULE$.Int());
        clusterings.foreach((Function1 & Serializable)clustering -> {
            clustering.foreach((Function1 & Serializable)cluster -> {
                ClusteringSummary$.$anonfun$expectedPairwiseAllocationMatrix$2(x$26, cluster);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        double cl = clusterings.length();
        return (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x), (Function1 & Serializable)x$1 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x$1), (Function1)(JFunction1.mcDI.sp & Serializable)x$2 -> (double)x$2 / cl, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[][] expectedPairwiseAllocationMatrix(int[][] clusterings) {
        int n = clusterings[0].length;
        int[][] x = (int[][])Array$.MODULE$.ofDim(n, n, (ClassTag)ClassTag$.MODULE$.Int());
        for (int k = 0; k < clusterings.length; ++k) {
            int[] p = clusterings[k];
            for (int i = 0; i < n; ++i) {
                int[] xi = x[i];
                int pi = p[i];
                for (int j = 0; j < n; ++j) {
                    if (pi != p[j]) continue;
                    int n2 = j;
                    xi[n2] = xi[n2] + 1;
                }
            }
        }
        double cl = clusterings.length;
        return (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x), (Function1 & Serializable)x$3 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x$3), (Function1)(JFunction1.mcDI.sp & Serializable)x$4 -> (double)x$4 / cl, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public Tuple5<double[], double[][], int[], int[], int[]> confidenceComputations(int[] clustering, double[][] pam) {
        Clustering clustering2 = Clustering$.MODULE$.apply((JFunction1.mcII.sp & Serializable)i -> i, (Iterable<Object>)Predef$.MODULE$.wrapIntArray(clustering));
        double[] confidence = (double[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), clustering2.nItems()).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> {
            double[] pami = pam[i];
            Cluster cluster = clustering2.clusterFor(i);
            return BoxesRunTime.unboxToDouble((Object)cluster.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable)(sum, j) -> sum + pami[j])) / (double)cluster.size();
        }).toArray((ClassTag)ClassTag$.MODULE$.Double());
        Map sizes = ((IterableOnceOps)clustering2.map((Function1 & Serializable)cluster -> new Tuple2(cluster, (Object)BoxesRunTime.boxToInteger((int)cluster.size())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        List clusters = (List)clustering2.toList().sortWith((Function2 & Serializable)(c1, c2) -> BoxesRunTime.boxToBoolean((boolean)ClusteringSummary$.$anonfun$confidenceComputations$5(sizes, c1, c2)));
        int[] confidenceMatrixLabels = (int[])clusters.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ClusteringSummary$.$anonfun$confidenceComputations$6(x$5))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        double[][] confidenceMatrix = (double[][])clusters.map((Function1 & Serializable)cluster1 -> (double[])clusters.map((Function1 & Serializable)cluster2 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$confidenceComputations$8(cluster1, pam, cluster2))).toArray((ClassTag)ClassTag$.MODULE$.Double())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int[] exemplar = (int[])clusters.map((Function1 & Serializable)cluster -> (List)cluster.toList().sortWith((Function2)(JFunction2.mcZII.sp & Serializable)(i, j) -> confidence[i] > confidence[j] ? true : (confidence[i] == confidence[j] ? i < j : false))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)ClusteringSummary$.$anonfun$confidenceComputations$13(x$6))).toArray((ClassTag)ClassTag$.MODULE$.Int());
        int[] orderList = (int[])((List)clusters.zip((IterableOnce)Predef$.MODULE$.wrapIntArray(exemplar))).flatMap((Function1 & Serializable)x -> this.findBest$1(((Cluster)x._1()).x().$minus((Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())).toList(), (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{x._2$mcI$sp()})), pam)).toArray((ClassTag)ClassTag$.MODULE$.Int());
        return new Tuple5((Object)confidence, (Object)confidenceMatrix, (Object)confidenceMatrixLabels, (Object)orderList, (Object)exemplar);
    }

    public <A> double lowerBoundVariationOfInformation(Clustering<A> clustering, double[][] pam) {
        int nItems = clustering.nItems();
        double sum1 = 0.0;
        for (int i = 0; i < nItems; ++i) {
            int sum2 = 0;
            double sum3 = 0.0;
            double sum4 = 0.0;
            for (int j = 0; j < nItems; ++j) {
                sum2 += clustering.paired(i, j) ? 1 : 0;
                sum3 += pam[i][j];
                sum4 += clustering.paired(i, j) ? pam[i][j] : 0.0;
            }
            sum1 += FastMath.log((double)2.0, (double)sum2) + FastMath.log((double)2.0, (double)sum3) - (double)2 * FastMath.log((double)2.0, (double)sum4);
        }
        return sum1 / (double)nItems;
    }

    /*
     * WARNING - void declaration
     */
    private <A> double lowerBoundVariationOfInformationEngine(Clustering<A> clustering, double[][] pam) {
        void var3_3;
        double sum = 0.0;
        Cluster[] clusters = (Cluster[])clustering.toArray(ClassTag$.MODULE$.apply(Cluster.class));
        for (int k = 0; k < clusters.length; ++k) {
            int[] cluster = (int[])clusters[k].toArray(ClassTag$.MODULE$.Int());
            sum += (double)cluster.length * FastMath.log((double)2.0, (double)cluster.length);
            double sum2 = 0.0;
            for (int ii = 0; ii < cluster.length; ++ii) {
                double sum3 = 0.0;
                double[] pamii = pam[cluster[ii]];
                for (int jj = 0; jj < cluster.length; ++jj) {
                    sum3 += pamii[cluster[jj]];
                }
                sum2 += FastMath.log((double)2.0, (double)sum3);
            }
            sum -= (double)2 * sum2;
        }
        return (double)var3_3;
    }

    public <A> double sumOfAbsolutesSlow(Clustering<A> clustering, double[][] pam) {
        return BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])new Array2DRowRealMatrix((double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])clustering.pairwiseAllocationMatrix()), (Function1 & Serializable)x$10 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x$10), (Function1)(JFunction1.mcDI.sp & Serializable)x$11 -> x$11, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))), false).subtract(new Array2DRowRealMatrix(pam, false)).getDataRef()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$12, x$13) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sumOfAbsolutesSlow$3(BoxesRunTime.unboxToDouble((Object)x$12), x$13))));
    }

    public <A> double sumOfSquaresSlow(Clustering<A> clustering, double[][] pam) {
        return BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])new Array2DRowRealMatrix((double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])clustering.pairwiseAllocationMatrix()), (Function1 & Serializable)x$14 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x$14), (Function1)(JFunction1.mcDI.sp & Serializable)x$15 -> x$15, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))), false).subtract(new Array2DRowRealMatrix(pam, false)).getDataRef()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(x$16, x$17) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sumOfSquaresSlow$3(BoxesRunTime.unboxToDouble((Object)x$16), x$17))));
    }

    private <A> double binderOffset(double[][] pam, Function1<Object, Object> f) {
        double offset = 0.0;
        for (int i = 1; i < pam.length; ++i) {
            double[] pi = pam[i];
            for (int j = 0; j < i; ++j) {
                offset += f.apply$mcDD$sp(pi[j]);
            }
        }
        return (double)2 * offset;
    }

    public <A> double sumOfAbsolutes(Clustering<A> clustering, double[][] pam) {
        double[][] pamTransform = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])pam), (Function1 & Serializable)x$18 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(x$18), (Function1)(JFunction1.mcDD.sp & Serializable)x -> (double)2 - (double)4 * x, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return this.binderOffset(pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x))) + this.binderEngine(clustering, pamTransform);
    }

    public <A> double sumOfSquares(Clustering<A> clustering, double[][] pam) {
        double[][] pamTransform = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])pam), (Function1 & Serializable)x$19 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(x$19), (Function1)(JFunction1.mcDD.sp & Serializable)x -> (double)2 - (double)4 * x, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return this.binderOffset(pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x -> x * x) + this.binderEngine(clustering, pamTransform);
    }

    private <A> double binderEngine(Clustering<A> clustering, double[][] pamTransform) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        clustering.foreach((Function1 & Serializable)cluster -> {
            ClusteringSummary$.$anonfun$binderEngine$1(pamTransform, sum, cluster);
            return BoxedUnit.UNIT;
        });
        return sum.elem;
    }

    private Tuple2<Cluster<Null$>, Object> emptyTuple() {
        return emptyTuple;
    }

    private List<Tuple2<Cluster<Null$>, Object>> binderShortcutEngine(int i, Clustering<Null$> clusteringWithoutI, int maxSize, double[][] pamTransform) {
        List list;
        double[] pamTransformi = pamTransform[i];
        List candidates = ((IterableOnceOps)clusteringWithoutI.map((Function1 & Serializable)cluster -> new Tuple2(cluster, (Object)cluster.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable)(sum, j) -> sum + pamTransformi[j])))).toList();
        if (maxSize <= 0 || clusteringWithoutI.size() < maxSize) {
            Tuple2<Cluster<Null$>, Object> tuple2 = this.emptyTuple();
            list = candidates.$colon$colon(tuple2);
        } else {
            list = candidates;
        }
        return list;
    }

    private List<Tuple2<Cluster<Null$>, Object>> lowerBoundVariationOfInformationShortcutEngine(int i, Clustering<Null$> clusteringWithoutI, int maxSize, double[][] pam) {
        List list;
        List candidates = ((IterableOnceOps)clusteringWithoutI.map((Function1 & Serializable)cluster -> new Tuple2(cluster, (Object)BoxesRunTime.boxToDouble((double)MODULE$.lowerBoundVariationOfInformationEngine(clusteringWithoutI.add(i, (Cluster<Null$>)cluster), pam))))).toList();
        if (maxSize <= 0 || clusteringWithoutI.size() < maxSize) {
            Tuple2 tuple2 = new Tuple2(Cluster$.MODULE$.empty(null), (Object)BoxesRunTime.boxToDouble((double)this.lowerBoundVariationOfInformationEngine(clusteringWithoutI.add(i, Cluster$.MODULE$.empty(null)), pam)));
            list = candidates.$colon$colon((Object)tuple2);
        } else {
            list = candidates;
        }
        return list;
    }

    public <A> Clustering<A> minAmongDraws(Seq<Clustering<A>> candidates, int maxSize, boolean multicore, String loss, Option<double[][]> pamOption) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        double[][] pam = (double[][])pamOption.getOrElse((Function0 & Serializable)() -> MODULE$.expectedPairwiseAllocationMatrix((Seq)candidates));
        Tuple3<Function2<Clustering<A>, double[][], Object>, Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>>, double[][]> tuple3 = this.getLoss(maxSize, loss, pam);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Function2 lossEngine = (Function2)tuple3._1();
        Function2 shortcutEngine = (Function2)tuple3._2();
        double[][] pamTransform = (double[][])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)lossEngine, (Object)shortcutEngine, (Object)pamTransform);
        Tuple3 tuple33 = tuple32;
        Function2 lossEngine2 = (Function2)tuple33._1();
        Function2 shortcutEngine2 = (Function2)tuple33._2();
        double[][] pamTransform2 = (double[][])tuple33._3();
        Iterator iter = (multicore ? ParVector$.MODULE$.apply(candidates) : candidates).iterator();
        return (Clustering)iter.minBy((Function1 & Serializable)clustering -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$minAmongDraws$2(maxSize, lossEngine2, pamTransform2, clustering)), (Ordering)this.ordering());
    }

    private Clustering<Null$> sequentiallyAllocatedLatentStructureOptimizationOld(Clustering<Null$> initial, int maxSize, List<Object> permutation, double[][] pamTransform, Function2<Clustering<Null$>, double[][], Object> lossEngine) {
        ObjectRef clustering = ObjectRef.create(initial);
        permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            List list;
            List candidates = ((IterableOnceOps)((Clustering)clustering$1.elem).map((Function1 & Serializable)cluster -> ((Clustering)clustering$1.elem).add(i, cluster))).toList();
            if (maxSize <= 0 || ((Clustering)clustering$1.elem).size() < maxSize) {
                Clustering<Object> clustering = ((Clustering)clustering$1.elem).add(Cluster$.MODULE$.apply(null, i));
                list = candidates.$colon$colon(clustering);
            } else {
                list = candidates;
            }
            List candidates2 = list;
            clustering$1.elem = (Clustering)candidates2.minBy((Function1 & Serializable)x$21 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimizationOld$3(lossEngine, pamTransform, x$21)), (Ordering)MODULE$.ordering());
        });
        return (Clustering)clustering.elem;
    }

    public Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>> mkShortcutEngineBinder(int maxSize, double[][] pamTransform) {
        return (Function2 & Serializable)(i, clusteringWithoutI) -> ClusteringSummary$.MODULE$.binderShortcutEngine(BoxesRunTime.unboxToInt((Object)i), clusteringWithoutI, maxSize, pamTransform);
    }

    public Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>> mkShortcutEngineLowerBoundVariationOfInformation(int maxSize, double[][] pam) {
        return (Function2 & Serializable)(i, clusteringWithoutI) -> ClusteringSummary$.MODULE$.lowerBoundVariationOfInformationShortcutEngine(BoxesRunTime.unboxToInt((Object)i), clusteringWithoutI, maxSize, pam);
    }

    private Tuple2<Clustering<Null$>, Object> sequentiallyAllocatedLatentStructureOptimization(Clustering<Null$> initial, int maxScans, List<Object> permutation, Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>> engine) {
        ObjectRef clustering = ObjectRef.create(initial);
        BooleanRef firstPass = BooleanRef.create((boolean)true);
        boolean notDone = true;
        int scanCounter = -1;
        while (firstPass.elem || notDone) {
            ++scanCounter;
            Clustering previousClustering = (Clustering)clustering.elem;
            permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (!firstPass$1.elem) {
                    clustering$2.elem = ((Clustering)clustering$2.elem).remove(i);
                }
                List candidates = (List)engine.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)((Clustering)clustering$2.elem));
                clustering$2.elem = ((Clustering)clustering$2.elem).add(i, (Cluster)((Tuple2)candidates.minBy((Function1 & Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22._2$mcD$sp()), (Ordering)MODULE$.ordering()))._1());
            });
            if (firstPass.elem) {
                firstPass.elem = false;
            }
            Clustering clustering2 = (Clustering)clustering.elem;
            Clustering clustering3 = previousClustering;
            notDone = (clustering2 == null ? clustering3 != null : !((Object)clustering2).equals(clustering3)) && scanCounter < maxScans;
        }
        return new Tuple2((Object)((Clustering)clustering.elem), (Object)BoxesRunTime.boxToInteger((int)scanCounter));
    }

    private <A> Tuple3<Function2<Clustering<A>, double[][], Object>, Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>>, double[][]> getLoss(int maxSize, String loss, double[][] pam2) {
        Tuple3 tuple3;
        String string = loss;
        boolean bl = "binder".equals(string) ? true : ("squaredError".equals(string) ? true : "absoluteError".equals(string));
        if (bl) {
            double[][] pamTransform2 = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])pam2), (Function1 & Serializable)x$23 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(x$23), (Function1)(JFunction1.mcDD.sp & Serializable)x -> 0.5 - x, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            tuple3 = new Tuple3((Function2 & Serializable)(clustering, pamTransform) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.MODULE$.binderEngine(clustering, pamTransform)), this.mkShortcutEngineBinder(maxSize, pamTransform2), (Object)pamTransform2);
        } else if ("lowerBoundVariationOfInformation".equals(string)) {
            tuple3 = new Tuple3((Function2 & Serializable)(clustering, pam) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.MODULE$.lowerBoundVariationOfInformationEngine(clustering, pam)), this.mkShortcutEngineLowerBoundVariationOfInformation(maxSize, pam2), (Object)pam2);
        } else {
            throw new MatchError((Object)string);
        }
        return tuple3;
    }

    public Tuple3<Clustering<Null$>, Object, Object> sequentiallyAllocatedLatentStructureOptimization(int nCandidates, double budgetInSeconds, double[][] pam, int maxSize, int maxScans, boolean multicore, String loss, boolean useOldImplementation) {
        Tuple3 tuple3 = this.getLoss(maxSize, loss, pam);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Function2 lossEngine = (Function2)tuple3._1();
        Function2 shortcutEngine = (Function2)tuple3._2();
        double[][] pamTransform = (double[][])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)lossEngine, (Object)shortcutEngine, (Object)pamTransform);
        Tuple3 tuple33 = tuple32;
        Function2 lossEngine2 = (Function2)tuple33._1();
        Function2 shortcutEngine2 = (Function2)tuple33._2();
        double[][] pamTransform2 = (double[][])tuple33._3();
        Random rng = new Random();
        int nItems = pam.length;
        List ints = (List)List$.MODULE$.tabulate(nItems, (Function1)(JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))));
        Clustering empty = Clustering$.MODULE$.empty();
        int nCores = multicore ? Runtime.getRuntime().availableProcessors() : 1;
        int nCandidatesPerThread = (nCandidates - 1) / nCores + 1;
        double budgetInMillis = budgetInSeconds <= 0.0 ? 9.223372036854776E18 : budgetInSeconds * (double)1000L;
        long start = System.currentTimeMillis();
        List futures = (List)List$.MODULE$.fill(nCores, (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            int counter;
            double minScore = Double.POSITIVE_INFINITY;
            Tuple2 best = new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)-1));
            for (counter = 0; counter < nCandidatesPerThread && (double)(System.currentTimeMillis() - start) <= budgetInMillis; ++counter) {
                List permutation = (List)rng.shuffle((IterableOnce)ints, BuildFrom$.MODULE$.buildFromIterableOps());
                Tuple2 tuple2 = !useOldImplementation ? MODULE$.sequentiallyAllocatedLatentStructureOptimization(empty, maxScans, (List<Object>)permutation, (Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>>)shortcutEngine2) : new Tuple2(MODULE$.sequentiallyAllocatedLatentStructureOptimizationOld(empty, maxSize, (List<Object>)permutation, pamTransform2, (Function2<Clustering<Null$>, double[][], Object>)lossEngine2), (Object)BoxesRunTime.boxToInteger((int)-1));
                Tuple2 candidate = tuple2;
                double score = BoxesRunTime.unboxToDouble((Object)lossEngine2.apply(candidate._1(), (Object)pamTransform2));
                if (!(score < minScore)) continue;
                minScore = score;
                best = candidate;
            }
            return new Tuple4(best._1(), (Object)BoxesRunTime.boxToInteger((int)best._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)minScore), (Object)BoxesRunTime.boxToInteger((int)counter));
        }, ExecutionContext.Implicits$.MODULE$.global()));
        List seq = (List)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)futures, BuildFrom$.MODULE$.buildFromIterableOps(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
        int nCandidatesInPractice = BoxesRunTime.unboxToInt((Object)seq.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(sum, tuple) -> BoxesRunTime.boxToInteger((int)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$6(BoxesRunTime.unboxToInt((Object)sum), tuple))));
        Tuple4 best = (Tuple4)seq.minBy((Function1 & Serializable)x$25 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$7(x$25)), (Ordering)this.ordering());
        return new Tuple3(best._1(), best._2(), (Object)BoxesRunTime.boxToInteger((int)nCandidatesInPractice));
    }

    public static final /* synthetic */ void $anonfun$expectedPairwiseAllocationMatrix$2(int[][] x$26, Cluster cluster) {
        int[] y = (int[])cluster.toArray(ClassTag$.MODULE$.Int());
        for (int i = 0; i < y.length; ++i) {
            int ii = y[i];
            for (int j = i + 1; j < y.length; ++j) {
                int jj = y[j];
                int[] nArray = x$26[ii];
                nArray[jj] = nArray[jj] + 1;
                int[] nArray2 = x$26[jj];
                nArray2[ii] = nArray2[ii] + 1;
            }
            int[] nArray = x$26[ii];
            nArray[ii] = nArray[ii] + 1;
        }
    }

    public static final /* synthetic */ boolean $anonfun$confidenceComputations$5(Map sizes$1, Cluster c1, Cluster c2) {
        return BoxesRunTime.unboxToInt((Object)sizes$1.apply((Object)c1)) > BoxesRunTime.unboxToInt((Object)sizes$1.apply((Object)c2));
    }

    public static final /* synthetic */ int $anonfun$confidenceComputations$6(Cluster x$5) {
        return BoxesRunTime.unboxToInt(x$5.parameter());
    }

    public static final /* synthetic */ double $anonfun$confidenceComputations$8(Cluster cluster1$1, double[][] pam$1, Cluster cluster2) {
        return BoxesRunTime.unboxToDouble((Object)cluster1$1.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable)(sum1, i) -> {
            double[] pami = pam$1[i];
            return sum1 + BoxesRunTime.unboxToDouble((Object)cluster2.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable)(sum2, j) -> sum2 + pami[j]));
        })) / (double)(cluster1$1.size() * cluster2.size());
    }

    public static final /* synthetic */ int $anonfun$confidenceComputations$13(List x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6.head());
    }

    public static final /* synthetic */ Tuple2 $anonfun$confidenceComputations$15(List members$1, double[][] pam$1, int y) {
        return new Tuple2.mcDI.sp(BoxesRunTime.unboxToDouble((Object)members$1.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDI.sp & Serializable)(sum, j) -> sum + pam$1[y][j])), y);
    }

    public static final /* synthetic */ boolean $anonfun$confidenceComputations$17(Tuple2 x$7, Tuple2 x$8) {
        return x$7._1$mcD$sp() > x$8._1$mcD$sp();
    }

    private final List findBest$1(List candidates, List members, double[][] pam$1) {
        while (!candidates.isEmpty()) {
            int best;
            int n = best = ((Tuple2)((IterableOps)candidates.map((Function1 & Serializable)y -> ClusteringSummary$.$anonfun$confidenceComputations$15(members, pam$1, BoxesRunTime.unboxToInt((Object)y))).sortWith((Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)ClusteringSummary$.$anonfun$confidenceComputations$17(x$7, x$8)))).head())._2$mcI$sp();
            members = members.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
            candidates = candidates.filterNot((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> x$9 == best);
        }
        return members;
    }

    public static final /* synthetic */ double $anonfun$sumOfAbsolutesSlow$3(double x$12, double[] x$13) {
        return x$12 + BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(x$13), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, b) -> a + RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(b))));
    }

    public static final /* synthetic */ double $anonfun$sumOfSquaresSlow$3(double x$16, double[] x$17) {
        return x$16 + BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(x$17), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(a, b) -> a + b * b));
    }

    public static final /* synthetic */ void $anonfun$binderEngine$1(double[][] pamTransform$1, DoubleRef sum$1, Cluster cluster) {
        int[] y = (int[])cluster.toArray(ClassTag$.MODULE$.Int());
        for (int i = 0; i < y.length; ++i) {
            double[] xx = pamTransform$1[y[i]];
            for (int j = i + 1; j < y.length; ++j) {
                sum$1.elem += xx[y[j]];
            }
        }
    }

    public static final /* synthetic */ double $anonfun$minAmongDraws$2(int maxSize$1, Function2 lossEngine$1, double[][] pamTransform$2, Clustering clustering) {
        return maxSize$1 > 0 && clustering.size() > maxSize$1 ? Double.POSITIVE_INFINITY : BoxesRunTime.unboxToDouble((Object)lossEngine$1.apply((Object)clustering, (Object)pamTransform$2));
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimizationOld$3(Function2 lossEngine$2, double[][] pamTransform$3, Clustering x$21) {
        return BoxesRunTime.unboxToDouble((Object)lossEngine$2.apply((Object)x$21, (Object)pamTransform$3));
    }

    public static final /* synthetic */ int $anonfun$sequentiallyAllocatedLatentStructureOptimization$6(int sum, Tuple4 tuple) {
        return sum + BoxesRunTime.unboxToInt((Object)tuple._4());
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$7(Tuple4 x$25) {
        return BoxesRunTime.unboxToDouble((Object)x$25._3());
    }

    private ClusteringSummary$() {
    }
}

