% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_scrobbles.R
\name{convert}
\alias{convert}
\title{convert}
\usage{
convert(unix_col, to, ...)
}
\arguments{
\item{unix_col}{A column in a dataframe of 10 digit unix numbers.}

\item{to}{One of 'Date' or 'Time'. Determines whether you get a datestamp of timestamp.}

\item{...}{Additional arguments to be passed to anytime::anytime or anytime::anydate.}
}
\value{
Date vector
}
\description{
Convert a unix timestamp to either a datestamp or timestamp
}
\examples{
unix_time <- "1522124746"
timestamp <- convert(unix_time, to = "Time")


my_tracks <- read_scrobbles(system.file("extdata", "scrobbles.txt", package = "scrobbler"))
my_tracks$Date <- convert(my_tracks$Date, to = "Time")
}
