% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_scatterpie.R
\name{geom_scatterpie}
\alias{geom_scatterpie}
\title{geom_scatterpie}
\usage{
geom_scatterpie(
  mapping = NULL,
  data,
  cols,
  pie_scale = 1,
  sorted_by_radius = FALSE,
  legend_name = "type",
  long_format = FALSE,
  label_radius = NULL,
  label_show_ratio = TRUE,
  label_threshold = 0,
  donut_radius = NULL,
  bg_circle_radius = NULL,
  ...
)
}
\arguments{
\item{mapping}{aes mapping}

\item{data}{data}

\item{cols}{cols the pie data}

\item{pie_scale}{amount to scale the pie size if there is no radius mapping exists}

\item{sorted_by_radius}{whether plotting large pie first}

\item{legend_name}{name of fill legend}

\item{long_format}{logical whether use long format of input data}

\item{label_radius}{numeric the radius of label position (relative the radius of pie),
default is NULL, when it is provided, the ratio or value label will be displayed.}

\item{label_show_ratio}{logical only work when \code{label_radius} is not NULL,
default is TRUE, meaning the ratio of label will be displayed.}

\item{label_threshold}{numeric the threshold is to control display the label, the ratio of 
slice pie smaller than the threshold will not be displayed. default is 0.}

\item{donut_radius}{numeric the radius of donut chart (relative the radius of circle), default is NULL.
it should be between 0 and 1, if it is provided, the donut chart will be displayed instead of pie chart.}

\item{bg_circle_radius}{numeric the radius of background circle, default is FALSE, we suggest setting it 
to between 1 and 1.5 .}

\item{...}{additional parameters}
}
\value{
layer
}
\description{
scatter pie plot
}
\examples{
library(ggplot2)
d <- data.frame(x=rnorm(5), y=rnorm(5))
d$A <- abs(rnorm(5, sd=1))
d$B <- abs(rnorm(5, sd=2))
d$C <- abs(rnorm(5, sd=3))

ggplot() + 
geom_scatterpie(
  aes(x=x, y=y), data=d, cols=c("A", "B", "C")
) + 
coord_fixed()

ggplot() + 
geom_scatterpie(
  aes(x=x, y=y), data = d, cols=c("A", "B", "C"), 
  label_radius=1.05
) + 
coord_fixed()

d <- tidyr::gather(d, key="letters", value="value", -x:-y)
ggplot() + geom_scatterpie(aes(x=x, y=y), data=d, cols="letters", long_format=TRUE) + coord_fixed()
p1 <- ggplot() + 
      geom_scatterpie(
        mapping = aes(x=x, y=y), data=d, cols="letters", 
        long_format=TRUE, 
        donut_radius=.5
      ) + 
      coord_fixed()
p1
p2 <- ggplot() + 
      geom_scatterpie(
        mapping = aes(x=x, y=y), data=d, cols="letters", 
        long_format=TRUE, 
        donut_radius = .5, 
        bg_circle_radius = 1.2
      ) + 
      coord_fixed()
p2
d |> dplyr::select(c(x, y)) |> dplyr::distinct() |> dplyr::mutate(Cell=c('A','A','B','C','B')) -> d2
d |> dplyr::left_join(d2) -> d3
d3$r_size <- c(2, 3, 4, 5, 6) * .01

head(d3)
p3 <- ggplot() +
     geom_scatterpie(data = d3, mapping = aes(x=x, y=y, r = r_size, color=Cell), cols="letters",
                     long_format=TRUE, donut_radius=.5, color = NA, linewidth=2,
                      bg_circle_radius=1.2) + coord_fixed()
p3

p4 <- ggplot() +
      geom_scatterpie(data = d3,
                      mapping = aes(x, y = y, r = r_size),
                      cols = 'letters',
                      long_format = TRUE,
                      label_radius = 1.1,
                      label_show_ratio = FALSE,
                      label_threshold = 0.06,
                      fontsize = 3
      ) +
      coord_fixed()
p4
}
\author{
Guangchuang Yu
}
