% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory_inference.R
\name{preprocessing}
\alias{preprocessing}
\title{preprocessing}
\usage{
preprocessing(expr)
}
\arguments{
\item{expr}{The gene expression matrix.}
}
\value{
List with the following keys:
\itemize{
\item expr - Gene expression matrix, with rows represent samples and columns represent genes.
}
}
\description{
Conduct preprocessing, including remove all zero columns and scale gene expression smaller than 100 by log transformation with 2 as base.
}
\examples{
#Load the package
library(scTEP)
#Load example data
data("goolam")
#Get data matrix
expr <- as.matrix(t(SummarizedExperiment::assay(goolam)))

data = preprocessing(expr)
}
