% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_gsea.R
\name{plot_select_sets}
\alias{plot_select_sets}
\title{Plot enrichment results for hand picked gene sets}
\usage{
plot_select_sets(
  container,
  factors_all,
  sets_plot,
  color_sets = NULL,
  cl_rows = FALSE,
  h_w = NULL,
  myfontsize = 8
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{factors_all}{numeric Vector of one or more factor numbers to get plots for}

\item{sets_plot}{character Vector of gene set names to show enrichment values for}

\item{color_sets}{named character Values are colors corresponding to each set,
with names as the gene set names (default=NULL)}

\item{cl_rows}{logical Set to TRUE to cluster gene set results (default=FALSE)}

\item{h_w}{numeric Vector specifying height and width (defualt=NULL)}

\item{myfontsize}{numeric Gene set label fontsize (default=8)}
}
\value{
A list with a ComplexHeatmap object of select enriched gene sets as the first element
and with a legend object as the second element.
}
\description{
Plot enrichment results for hand picked gene sets
}
