% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_word_freqs.R
\name{get_word_freqs}
\alias{get_word_freqs}
\title{Word frequency tables}
\usage{
get_word_freqs(text, .preprocess = preprocess, EOS = ".?!:;")
}
\arguments{
\item{text}{a character vector. The training corpus from which to extract
word frequencies.}

\item{.preprocess}{a function for corpus preprocessing. Takes a character
vector as input and returns a character vector.}

\item{EOS}{a length one character vector listing all (single character)
end-of-sentence tokens.}
}
\value{
A named integer containing word frequencies.
}
\description{
Get word frequency tables from a training corpus.
}
\examples{
\donttest{
# Get word frequencies and extract dictionary of top 1000 words
words <- get_word_freqs(twitter_train)
words
dict <- names(words)[1:1000]
}
}
\author{
Valerio Gherardi
}
