% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{rMevlog}
\alias{rMevlog}
\alias{pMevlog}
\alias{dMevlog}
\alias{ellMevlog}
\title{r-p-d-ell- functions for Mevlog models.}
\usage{
rMevlog(n, ds, mar = c(1,1,1))
pMevlog(x, ds, mar = c(1,1,1))
dMevlog(x, ds, mar = c(1,1,1))
ellMevlog(x, ds)
}
\arguments{
\item{n}{The number of observations.}

\item{ds}{An object of class \code{ds}.}

\item{mar}{A vector of length 3 or a \code{(d times 3)} matrix.  See details.}

\item{x}{A vector of size \code{d} or a matrix with \code{d} columns.}
}
\value{
\code{rMevlog}  returns a \code{(n times d)}  matrix  containing \code{n} realizations of a \code{d}-variate Mevlog random vector with margins \code{mar} and tail dependence structure \code{ds}.

 \code{pMevlog} returns a  scalar (when \code{x} is a numeric vector) or a vector (when \code{x} is a numeric matrix, in which case the evaluation is done across the rows). The margins are provided by \code{mar} and the tail dependence structure through a \code{ds} object.

 \code{dMevlog} returns a  scalar (when \code{x} is a numeric vector) or a vector (when \code{x} is a numeric matrix, in which case the evaluation is done across the rows). The margins are provided by \code{mar} and the tail  dependence structure through a \code{ds} object.

 \code{ellMevlog} returns a  scalar (when \code{x} is a numeric vector) or a vector (when \code{x} is a numeric matrix, in which case the evaluation is done across the rows). The tail dependence structure is provided by a \code{ds} object.
}
\description{
Random vectors generation (\code{rMevlog}),  cumulative distribution function (\code{pMevlog}), probability density function (\code{dMevlog}), stable tail dependence function (\code{ellMevlog}) for Mevlog models. A \code{Mevlog} model is a multivariate extreme value (symmetric or asymmetric) logistic model.
}
\details{
The tail dependence structure is set by a \code{ds} object.  See Section \bold{Value} in \code{\link[satdad]{gen.ds}}.

The marginal information \code{mar} is given by a 3-dimensional vector (the order should be location, scale and shape) or a matrix with 3 columns depending on whether the components share the same characteristics or not.   When the marginal parameters differ, \code{mar} is a matrix containing \eqn{d} locations in the first column, \eqn{d} scales in the second column and \eqn{d} shapes in the third column.

The (a)symmetric logistic models respectively are simulated in `rMevlog` using Algorithms 2.1 and 2.2 in Stephenson(2003).
}
\examples{
## Fix a 3-dimensional symmetric tail dependence structure
ds3 <- gen.ds(d = 3, type = "log")

## The dependence parameter is given by
ds3$dep

## Generate a 1000-sample of Mevlog random vectors associated with ds3
## The margins are kept as standard  Frechet
sample3 <- rMevlog(n = 1000, ds = ds3)

## Fix a 10-dimensional asymmetric tail dependence structure
# The option \cdoe{mns = 4} produces a support involving subsets of cardinality 4 plus singletons.
ds10 <- gen.ds(d = 10,  mnns = 4)
## Margins differ from one to another
mar10 <- matrix(runif(10*3), ncol = 3)

## Generate a 50-sample of Mevlog random vectors associated with ds10 and mar10
sample10 <- rMevlog(n = 50, ds = ds10, mar = mar10)

## Continuing with ds3 ; we compute other attributes
## The cumulative distribution function
pMevlog(x = rep(1,3), ds = ds3)
# should be similar to :
# evd::pmvevd(q = rep(1,3), dep = ds3$dep, model = "log", d = 3, mar = c(1,1,1))
## The probability density function:
dMevlog(x = rep(1,3), ds = ds3, mar = c(1.2,1,0.5))
# should be similar to :
# evd::dmvevd(x = rep(1,3), dep = ds3$dep, model = "log", d = 3, mar = c(1.2,1,0.5))
## The stable tail dependence function:
ellMevlog(x = rep(1,3), ds = ds3)

}
\references{
Gumbel, E. J. (1960)
Distributions des valeurs extremes en plusieurs dimensions.
\emph{Publ. Inst. Statist. Univ. Paris}, \bold{9}, 171--173.

Stephenson, A. (2002)
evd: Extreme Value Distributions.
\emph{R News}, 2(2):31--32.

Stephenson, A. (2003)
Simulating Multivariate Extreme Value Distributions of Logistic Type.
\emph{Extremes}, \bold{6}, 49--59.

Tawn, J. A. (1990)
Modelling multivariate extreme value distributions.
\emph{Biometrika}, \bold{77}, 245--253.
}
\seealso{
\code{\link[satdad]{gen.ds}}, \code{\link[satdad]{tsic}},  \code{\link[satdad]{ec}}, \code{\link[satdad]{graphs}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
