% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{ecEmp}
\alias{ecEmp}
\title{Empirical Extremal coefficients.}
\usage{
ecEmp(sample, ind = 2, k, norm = TRUE)
}
\arguments{
\item{sample}{A \code{(n times d)} matrix.}

\item{ind}{A character string among "with.singletons" and "all" (without singletons), or an integer in \eqn{\{2,...,d\}} or a list of subsets from  \eqn{\{1,...,d\}}. The default is \code{ind = 2}, all pairwise coefficients are computed.}

\item{k}{An integer smaller or equal to \code{n}.}

\item{norm}{A boolean. `FALSE` (the default): empirical ec is computed. `TRUE`:  inverse normalized empirical ec is computed.}
}
\value{
The function returns a list of two elements:
\itemize{
\item{\code{subsets}} A list of subsets from  \eqn{\{1,...,d\}}.

When \code{ind} is given as an integer, \code{subsets} is the list of subsets from  \eqn{\{1,...,d\}} with cardinality \code{ind}. When \code{ind} is the list, it corresponds to \code{subsets}.

When \code{ind = "with.singletons"}  subsets is the list of all non empty subsets in \eqn{\{1,...,d\}}.

When \code{ind = "all"}   subsets is the list of all subsets in \eqn{\{1,...,d\}} with cardinality larger or equal to 2.

\item{\code{ec}} A vector of empirical  extremal coefficients.

An empirical extremal coefficient associated with the subset \eqn{I} is \eqn{\hat{\ell}_{k,n}(1_I,0_{I^c})}. Its value lies in \eqn{(1, |I|)}.

When \code{norm = TRUE}, then inverse normalized empirical ec are computed by \eqn{1 - \dfrac{\hat{\ell}_{k,n}(1_I,0_{I^c})}{|I|}}.
}
}
\description{
Computes on a sample the extremal coefficients associated with threshold \code{k}.
}
\examples{
## We produce below a figure on the dataset used in Mercadier  and Roustant (2019).

data(France)

ec_ymt <- ecEmp(sample = France$ymt, ind = 2, k = 25)

## The 9 largest inverse empirical pairwise extremal coefficients.
 graphsMapEmp(France$ymt, region='france', coord=France$coord, k=25, which="iecgraph", select=9)

## The 30 largest inverse empirical pairwise extremal coefficients.
graphsMapEmp(France$ymt, region='france', coord=France$coord, k=25, which="iecgraph", select=30)

## All the inverse empirical pairwise extremal coefficients.
graphsMapEmp(France$ymt, region='france', coord=France$coord, k=25, which="iecgraph")

}
\seealso{
\code{\link[satdad]{ec}}, \code{\link[satdad]{ellEmp}},  \code{\link[satdad]{graphsEmp}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
