% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-query.R
\name{safe_bind_rows}
\alias{safe_bind_rows}
\title{Stack data frames which may have differing types in the same column}
\usage{
safe_bind_rows(l, fill = TRUE, idcol = NULL, ...)
}
\arguments{
\item{l}{\code{list}; A list containing data frames or lists that can be coerced
to data frames.}

\item{fill}{\code{logical}; \code{TRUE} fills missing columns with NA
(default \code{TRUE}). When \code{TRUE}, use.names is set to \code{TRUE}.}

\item{idcol}{\code{character}; Creates a column in the result showing which
list item those rows came from. TRUE names this column ".id". idcol="file"
names this column "file".}

\item{...}{arguments passed to \code{\link[data.table]{rbindlist}}}
}
\value{
\code{tbl_df}; all list elements stacked on top of each other to
form a single data frame
}
\description{
This function accepts a list of data frames and will stack them all and
return a \code{tbl_df} with missing values filled in and all columns stacked
regardless of if the datatypes were different within the same column.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
