% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixModel.R
\name{predict.SaemixModel}
\alias{predict.SaemixModel}
\title{Predictions for a new dataset}
\usage{
\method{predict}{SaemixModel}(object, predictors, psi = c(), id = c(), ...)
}
\arguments{
\item{object}{an SaemixModel object}

\item{predictors}{a dataframe with the predictors for the model (must correspond to the predictors used by the model function)}

\item{psi}{a vector or a dataframe giving the parameters for which predictions are to be computed (defaults to empty).
The number of columns in psi (or the number of elements of psi, if psi is given as a vector) should match the number of
parameters in the model, otherwise an error message will be shown and the function will return empty.
If psi is NA, the predictions are computed for the population parameters in the model (first line of the psi0 slot).
If psi is a dataframe, each line will be used for a separate 'subject' in the predictors dataframe, as
indicated by the id argument; if id is not given, only the first line of psi will be used.}

\item{id}{a vector of indices of length equal to the number of lines in predictors, matching each line of predictors to the
corresponding line in psi, ie the parameters for this predictors (defaults to empty). If id is given, the unique values in id must be equal
to the number of lines in psi, otherwise id will be set to 1. If id is given and its values do not take the consecutive values 1:N, the
indices will be matched to 1:N to follow the lines in psi.}

\item{\dots}{unused argument, for consistency with the generic}
}
\value{
a list with two components
\describe{
\item{param}{a dataframe with the estimated parameters}
\item{predictions}{a dataframe with the population predictions}
}
}
\description{
Predictions for a new dataset
}
\details{
The function uses the model slot of the SaemixModel object to obtain predictions, using the predictors object. The
user is responsible for giving all the predictors needed by the model function.
if psi is not given, the predictions will be computed for the population parameters (first line of the psi0 slot) of the object.

The predictions correspond to the structure of the model; for models defined in terms of their likelihood, the predictions
are the log-pdf of the model (see documentation for details).

Warning: this function is currently under development and the output may change in future versions of the package
to conform to the usual predict functions.
}
\examples{
data(theo.saemix)
xpred<-theo.saemix[,c("Dose","Time")]

model1cpt<-function(psi,id,xidep) { 
	  dose<-xidep[,1]
	  tim<-xidep[,2]  
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,modeltype="structural",
  description="One-compartment model with first-order absorption", 
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

head(predict(saemix.model, xpred)$predictions)
head(predict(saemix.model, xpred, psi=c(2, 40, 0.5))$predictions)
indpsi<-data.frame(ka=2, V=seq(25,47,2), CL=seq(2.5,4.7, 0.2))
head(predict(saemix.model, xpred, psi=indpsi)$predictions)

}
