context("test-mapcurves.R")

# tests are based on the work of
# Emiel van Loon
# University of Amsterdam
# http://www.uva.nl/en/profile/l/o/e.e.vanloon/e.e.vanloon.html

A1 = c( 4, 4, 6, 0, 7, 6, 1, 0, 2, NA
       , 4, 0, 8, 0, 8, 5, 0, 3, 3, 1
       , 4, 1, 6, 8, 1, 6, 6, 1, 8, 2
       , 5, 2, 1, 7, 0, 2, 7, 1, 8, 2
       , 3, 3, 5, 2, 8, 0, 6, 8, 6, 5
       , 4, 5, 5, 1, 7, 0, 0, 1, 7, 6
       , 6, 6, 7, 7, 0, 2, 0, 2, 3, 0
       , 8, 7, 2, 4, 7, 5, 6, 1, 6, 0
       , 0, 1, 3, 8, 8, 2, 8, 1, 7, 8
       , 4, 8, 7, 6, 5, 0, 7, 6, 2, 3)


A2 = c( NA, 6, 3, 0, 6, 3, 3, 1, 6, 8
       , 7, NA, 4, 0, 3, 7, 6, 0, 8, 7
       , 3, 3, 1, 4, 3, 4, 3, 6, 0, 5
       , 0, 4, 4, 6, 7, 0, 3, 3, 2, 7
       , 7, 4, 4, 7, 7, 7, 2, 8, 8, 7
       , 8, 2, 1, 1, 8, 8, 6, 6, 7, 1
       , 6, 8, 1, 4, 1, 7, 4, 7, 6, 5
       , 0, 5, 0, 2, 1, 1, 2, 7, 5, 7
       , 7, 0, 4, 1, 6, 0, 5, 2, 0, 6
       , 4, 6, 4, 7, 5, 3, 8, 0, 5, 8)

B1 = c( 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
       , 1, 1, 1, 1, 1, 1, 2, 2, 2, 1
       , 1, 1, 1, 1, 1, 1, 2, 2, 2, 1
       , 1, 1, 1, 1, 1, 1, 2, 2, 2, 1
       , 3, 3, 1, 1, 1, 2, 2, 2, 2, 1
       , 3, 3, 1, 1, 1, 2, 2, 2, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 4, 1
       , 1, 1, 1, 1, 1, 1, 1, 1, 4, 4)

B2 = c( 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
       , 1, 1, 1, 1, 1, 1, 2, 5, 5, 1
       , 1, 1, 1, 1, 1, 1, 2, 5, 5, 1
       , 1, 1, 1, 1, 1, 1, 2, 5, 5, 1
       , 3, 3, 1, 1, 1, 2, 2, 5, 5, 1
       , 3, 3, 1, 1, 1, 2, 2, 5, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 4, 1
       , 1, 1, 1, 1, 1, 1, 1, 1, 4, 4)

B3 = c( 1, 1, 1, 1, 1, 1, 1, 2, 1, 1
       , 1, 1, 1, 1, 1, 1, 2, 2, 5, 1
       , 1, 1, 1, 1, 1, 1, 2, 5, 5, 1
       , 1, 1, 1, 1, 1, 2, 2, 5, 5, 1
       , 3, 3, 1, 1, 1, 2, 2, 5, 5, 1
       , 3, 3, 1, 1, 1, 2, 2, 5, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 1, 1
       , 3, 3, 3, 1, 1, 1, 1, 1, 4, 1
       , 3, 3, 3, 1, 1, 1, 1, 4, 4, 4)

set.seed(2018-03-21)
A = floor(matrix(runif(100, 0, 9), 10))
B = floor(matrix(runif(100, 0, 9), 10))

A1 = matrix(data = A1, nrow = 10)
A2 = matrix(data = A2, nrow = 10)
B1 = matrix(data = B1, nrow = 10)
B2 = matrix(data = B2, nrow = 10)
B3 = matrix(data = B3, nrow = 10)

test_that("mapcurves works properly", {
  expect_equal(mapcurves(A, B)$gof, 0.1879148, tolerance = 3)
  expect_equal(mapcurves(A1, B2)$gof, 0.1655752, tolerance = 3)
  expect_equal(mapcurves(B1, B2)$gof, 1, tolerance = 3)
  expect_equal(mapcurves(B2, B3)$gof, 0.8194291, tolerance = 3)
  expect_equal(mapcurves(B1, B3)$gof, 0.8507659, tolerance = 3)
})
