% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwmGetClassBreaks.R
\name{rwmGetClassBreaks}
\alias{rwmGetClassBreaks}
\title{Internal function to set the numeric values for the breaks between data
categories}
\usage{
rwmGetClassBreaks(dataColumn, catMethod, numCats, verbose = TRUE,
  midpoint = 0)
}
\arguments{
\item{dataColumn}{the data vector to be classified, must be numeric}

\item{catMethod}{the method to use to classify the data into categories,
choice of "pretty", "fixedWidth", "diverging",
"logFixedWidth","quantiles","categorical" or a numeric vector defining
breaks}

\item{numCats}{number of categories to put the data in, may be overidden if
not possible under some classification methods}

\item{verbose}{whether to print information messages to console TRUE/FALSE}

\item{midpoint}{the midpoint to use if catMethod='diverging', default=0}
}
\value{
A vector specifying the numeric breaks between data categories.
}
\description{
Sets the values that determine how a vector of continuous data is classified
into categories. Called by mapCountryData() and mapGriddedData()
}
\author{
andy south and matthew staines
}
\seealso{
The classInt package
}
\keyword{dplot}

