% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vignette_getstarted.R
\name{use_vignette_getstarted}
\alias{use_vignette_getstarted}
\title{Use vignette: Get started}
\usage{
use_vignette_getstarted(
  package = names(get_description()),
  title = "Get started",
  vignette_index_entry = package,
  save_dir = here::here(),
  path = file.path(save_dir, "vignettes", paste0(package, ".Rmd")),
  output = "BiocStyle::html_document",
  force_new = FALSE,
  show = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{package}{R package name.}

\item{title}{Title of vignette.}

\item{vignette_index_entry}{Index entry of the vignette, 
which is used when creating the navigation bar in the \pkg{pkgdown} site.}

\item{save_dir}{Directory to save the file to.}

\item{path}{Path to the file.}

\item{output}{Vignette output style. 
Defaults to \link[BiocStyle]{html_document}.}

\item{force_new}{If the file already exists, overwrite it 
(default: \code{FALSE}).}

\item{show}{Print the contents of the file in the R console.}

\item{verbose}{Print messages.}
}
\value{
Path to vignette file.
}
\description{
Creates a "Get started" rmarkdown vignette file.
}
\examples{
path <- use_vignette_getstarted(package = "mypackage",
                                ## use default save_dir in practice
                                save_dir = tempdir())
}
