% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_rv.R
\name{summary.rv}
\alias{summary.rv}
\alias{summary.rvfactor}
\alias{summary.rvmixed}
\alias{summary.rvsummary}
\alias{summary.rvsummary_numeric}
\alias{summary.rvsummary_integer}
\alias{summary.rvsummary_logical}
\alias{summary.rvsummary_rvfactor}
\title{Numerical Summary of a Random Variable}
\usage{
\method{summary}{rv}(object, ...)
}
\arguments{
\item{object}{object to summarize}

\item{\dots}{rv object}

\item{all.levels}{show summary for all levels even if there are too many to
display in one line}
}
\description{
Gives a numerical summary of the random variable in the format of a data
frame.
}
\details{
The objects are first coerced to \code{rvsummary} objects, then passed on to
the \code{summary.rvsummary} method, which creates a nicely formatted data
frame of the object.
}
\examples{
\dontrun{

  x <- rvarray(rvnorm(6), c(2,3))
  summary(x)
  summary(as.rvsummary(x))
  summary(rvfactor(trunc(x)))
  }

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{internal}
