% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrREPEATED.r
\name{qpcrREPEATED}
\alias{qpcrREPEATED}
\title{Fold change (\eqn{\Delta \Delta C_T} method) analysis of repeated measure qPCR data}
\usage{
qpcrREPEATED(
  x,
  numberOfrefGenes,
  factor,
  block = NULL,
  width = 0.5,
  fill = "#BFEFFF",
  y.axis.adjust = 1,
  y.axis.by = 1,
  ylab = "Fold Change",
  xlab = "none",
  fontsize = 12,
  fontsizePvalue = 7,
  axis.text.x.angle = 0,
  axis.text.x.hjust = 0.5,
  x.axis.labels.rename = "none",
  letter.position.adjust = 0,
  p.adj = "none",
  errorbar = "se",
  plot = TRUE
)
}
\arguments{
\item{x}{input data frame in which the first column is id, 
followed by the factor(s) which include at least time factor. 
The first level of time factor in data set is used as calibrator or reference level.
Additional factor(s) may also be present. Other columns are efficiency and Ct values of target and reference genes.
In the "id" column, a unique number is assigned to each individual from which samples have been takes over time, 
for example in the \code{data_repeated_measure_1}, 
all the three number 1 indicate one individual which has been sampled over three different time courses.
To prepare a data frame from a  repeated measure analysis, please refer to the vignette.}

\item{numberOfrefGenes}{number of reference genes which is 1 or 2 (Up to two reference genes can be handled).
as reference or calibrator which is the reference level or sample that all others are compared to. Examples are untreated 
of time 0. The FC value of the reference or calibrator level is 1 because it is not changed compared to itself.
If NULL, the first level of the main factor column is used as calibrator.}

\item{factor}{the factor for which the FC values is analysed. The first level of the specified factor in the input data frame is used as calibrator.}

\item{block}{column name of the block if there is a blocking factor (for correct column arrangement see example data.). 
Block effect is usually considered as random and its interaction with any main effect is not considered.}

\item{width}{a positive number determining bar width in the output bar plot.}

\item{fill}{specify the fill color for the columns in the bar plot. If a vector of two colors is specified, the reference level is differentialy colored.}

\item{y.axis.adjust}{a negative or positive value for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length}

\item{ylab}{the title of the y axis}

\item{xlab}{the title of the x axis}

\item{fontsize}{font size of the plot}

\item{fontsizePvalue}{font size of the pvalue labels}

\item{axis.text.x.angle}{angle of x axis text}

\item{axis.text.x.hjust}{horizontal justification of x axis text}

\item{x.axis.labels.rename}{a vector replacing the x axis labels in the bar plot}

\item{letter.position.adjust}{adjust the distance between the signs and the error bars.}

\item{p.adj}{Method for adjusting p values}

\item{errorbar}{Type of error bar, can be \code{se} or \code{ci}.}

\item{plot}{if \code{FALSE}, prevents the plot.}
}
\value{
A list with 5 elements:
\describe{
  \item{Final_data}{Input data frame plus the weighted Delat Ct values (wDCt)}
  \item{lm}{lm of factorial analysis-tyle}
  \item{ANOVA_table}{ANOVA table}
  \item{FC Table}{Table of FC values, significance, confidence interval and standard error for the selected factor levels.}
  \item{Bar plot of FC values}{Bar plot of the fold change values for the main factor levels.}
}
}
\description{
\code{qpcrREPEATED} function performs fold change (\eqn{\Delta \Delta C_T} method) analysis of observations repeatedly taken over different time courses, 
Data may be obtained over time from a uni- or multi-factorial experiment. The bar plot of the fold changes (FC) 
values along with the standard error (se) or confidence interval (ci) is also returned by the \code{qpcrREPEATED} function.
}
\details{
The \code{qpcrREPEATED} function performs fold change (FC) analysis of observations repeatedly taken over time. 
The intended factor (could be time or any other factor) is defined for the analysis by the \code{factor} argument, then the function performs FC analysis on its levels
so that the first levels (as appears in the input data frame) is used as reference or calibrator. the function returns FC values along with confidence interval and standard error for the FC values.
}
\examples{

qpcrREPEATED(data_repeated_measure_1,
            numberOfrefGenes = 1,
            factor = "time")

qpcrREPEATED(data_repeated_measure_2,
             numberOfrefGenes = 1,
             factor = "time")
                                                       
                                                       
}
\author{
Ghader Mirzaghaderi
}
