% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_accessors.R
\name{row_footnotes}
\alias{row_footnotes}
\alias{row_footnotes<-}
\alias{cell_footnotes}
\alias{cell_footnotes<-}
\alias{col_fnotes_here}
\alias{col_fnotes_here,ANY-method}
\alias{col_fnotes_here<-}
\alias{col_footnotes}
\alias{col_footnotes<-}
\alias{ref_index}
\alias{ref_index<-}
\alias{ref_symbol}
\alias{ref_symbol<-}
\alias{ref_msg}
\alias{fnotes_at_path<-}
\title{Referential footnote accessors}
\usage{
row_footnotes(obj)

row_footnotes(obj) <- value

cell_footnotes(obj)

cell_footnotes(obj) <- value

col_fnotes_here(obj)

\S4method{col_fnotes_here}{ANY}(obj)

col_fnotes_here(obj) <- value

col_footnotes(obj)

col_footnotes(obj) <- value

ref_index(obj)

ref_index(obj) <- value

ref_symbol(obj)

ref_symbol(obj) <- value

ref_msg(obj)

fnotes_at_path(obj, rowpath = NULL, colpath = NULL, reset_idx = TRUE) <- value
}
\arguments{
\item{obj}{(\code{ANY})\cr the object for the accessor to access or modify.}

\item{value}{(\code{ANY})\cr the new value.}

\item{rowpath}{(\code{character} or \code{NULL})\cr path within row structure. \code{NULL} indicates the footnote should
go on the column rather than cell.}

\item{colpath}{(\code{character} or \code{NULL})\cr path within column structure. \code{NULL} indicates footnote should go
on the row rather than cell.}

\item{reset_idx}{(\code{flag})\cr whether the numbering for referential footnotes should be immediately
recalculated. Defaults to \code{TRUE}.}
}
\description{
Access and set the referential footnotes aspects of a built table.
}
\examples{
# How to add referencial footnotes after having created a table
lyt <- basic_table() \%>\%
  split_rows_by("SEX", page_by = TRUE) \%>\%
  analyze("AGE")

tbl <- build_table(lyt, DM)
tbl <- trim_rows(tbl)
# Check the row and col structure to add precise references
# row_paths(tbl)
# col_paths(t)
# row_paths_summary(tbl)
# col_paths_summary(tbl)

# Add the citation numbers on the table and relative references in the footnotes
fnotes_at_path(tbl, rowpath = c("SEX", "F", "AGE", "Mean")) <- "Famous paper 1"
fnotes_at_path(tbl, rowpath = c("SEX", "UNDIFFERENTIATED")) <- "Unfamous paper 2"
# tbl

}
\seealso{
\code{\link[=row_paths]{row_paths()}}, \code{\link[=col_paths]{col_paths()}}, \code{\link[=row_paths_summary]{row_paths_summary()}}, \code{\link[=col_paths_summary]{col_paths_summary()}}
}
